#include "mbed.h"
#include "uLCD_4DGL.h"
#include "glibr.h"
#include "PinDetect.h"
#include "string"
#include "SDFileSystem.h"
#include "wave_player.h"

glibr GSensor(p9,p10);

PinDetect pb2(p15);
SDFileSystem sd(p5, p6, p7, p8, "sd"); //SD card
AnalogOut DACout(p18);
wave_player waver(&DACout);
DigitalOut myled(LED1);
DigitalOut myled2(LED2);
Serial xbee2(p13, p14);
uLCD_4DGL lcd(p28, p27, p30);

#define DEBUGLCD 0
#ifdef DEBUGLCD
Serial pc2(USBTX,USBRX);
#endif
//DigitalOut INT(p11);
//uint16_t ambient_light = 0;
//uint16_t red_light = 0;
//uint16_t green_light = 0;
//uint16_t blue_light = 0;
//int volatile stop=0;
//int volatile go=0;
string str;


void setup()
{

    lcd.baudrate(3000000);
    lcd.background_color(0);
    lcd.cls();
    
    lcd.printf("Initializing...");
    wait(0.2);
    lcd.cls();
    lcd.color(RED); 
}

void printRIG(int column, int roww){
    lcd.cls();
    lcd.text_width(1);
    lcd.text_height(1);
    int col, row, r, c;    

    /* Draw staff of arrow */
    for(col=3; col<13; col++)
        for(row=5; row<10; row++)
            lcd.text_char('=', col, row, GREEN);

    /* Draw arrowhead */
    lcd.text_char('*', col-2, 4, GREEN); lcd.text_char('*', col-2, 3, GREEN); 
    lcd.text_char('*', col-1, 4, GREEN);         
    int a = 5, b=5;
    for(c = col; c<(col+3); c++){             
        for(r = a; r<(a+b); r++)
            lcd.text_char('*', c, r, GREEN);
        a++; b-=2;
    }       
    lcd.text_char('*', 11, row, GREEN); lcd.text_char('*', 11, row+1, GREEN); 
    lcd.text_char('*', 12, row, GREEN);
       
    /* Print Command String */        
    lcd.text_width(2);
    lcd.text_height(2);    
    lcd.text_string("RIG", column, roww, FONT_7X8, WHITE);
}

void printLEF(int column, int roww){
    lcd.cls();
    lcd.text_width(1);
    lcd.text_height(1);
    int col, row, r, c;    

    /* Draw staff of arrow */
    for(col=15; col>=6; col--)
        for(row=5; row<10; row++)
            lcd.text_char('=', col, row, GREEN);
    /* Draw arrowhead */
    lcd.text_char('*', col+2, 4, GREEN); lcd.text_char('*', col+2, 3, GREEN); lcd.text_char('*', col+1, 4, GREEN);                 
    lcd.text_char('*', col+2, row, GREEN); lcd.text_char('*', col+1, row, GREEN); lcd.text_char('*', col+2, row+1, GREEN);
    int a = 5, b=5;
    for(c = col; c>(col-3); c--){             
        for(r = a; r<(a+b); r++)
            lcd.text_char('*', c, r, GREEN);
        a++; b-=2;
    }

    /* Print Command String */        
    lcd.text_width(2);
    lcd.text_height(2);    
    lcd.text_string("LEF", column, roww, FONT_7X8, WHITE);
}

void printBWD(int column, int roww){
    lcd.cls();
    lcd.text_width(1);
    lcd.text_height(1);
    int col, row, r, c;

    /* Draw staff of arrow */
    for(row = 2; row<7; row++)
        for(col = 5; col<14; col++)
            lcd.text_char('|',col, row, GREEN);

    /* Draw arrowhead */
    lcd.text_char('_', col, row-1, GREEN); lcd.text_char('_', col+1, row-1, GREEN); 
    lcd.text_char('_', 4, row-1, GREEN); lcd.text_char('_', 3, row-1, GREEN); 
    int a = 5, b=8;
    for(r=row; r<=(row+5); r++){
        for(c=a; c<=(a+b); c++)
            lcd.text_char('*', c, r, GREEN);
        a++; b-=2;
    }

    /* Print Command String */        
    lcd.text_width(2);
    lcd.text_height(2);    
    lcd.text_string("BWD", column, roww, FONT_7X8, WHITE);        
}

void printFWD(int column, int roww){
    lcd.cls();
    lcd.text_width(1);
    lcd.text_height(1);
    int col, row, r, c;
 
    /* Draw staff of arrow */
    for(row = 10; row>=6; row--)
        for(col = 5; col<14; col++)
            lcd.text_char('|',col, row, GREEN);
 
    /* Draw arrowhead */
    lcd.text_char('_', col, row, GREEN); lcd.text_char('_', col+1, row, GREEN); 
    lcd.text_char('_', 4, row, GREEN); lcd.text_char('_', 3, row, GREEN); 
    int a = 5, b=8;
    for(r=row; r>=(row-5); r--){
        for(c=a; c<=(a+b); c++)
            lcd.text_char('*', c, r, GREEN);
        a++; b-=2;
    }
    
    /* Print Command String */        
        lcd.text_width(2);
        lcd.text_height(2);    
        lcd.text_string("FWD", column, roww, FONT_7X8, WHITE);  
}

void printERR(int column, int roww){
    lcd.cls();    
   // lcd.filled_circle(64 , 60 , 20, WHITE);          
    lcd.text_width(8);
    lcd.text_height(8);
    lcd.text_string("!!!", column, roww, FONT_7X8, RED);    
    lcd.text_string("!!!", column, roww+1, FONT_7X8, RED);
    lcd.text_width(2);
    lcd.text_height(2);
    lcd.text_string("ERR", 3, 7, FONT_7X8, WHITE);  
    
}

void printSTOP(int column, int roww){
    lcd.cls();    
    lcd.filled_circle(64 , 60 , 35, RED);        
    lcd.text_width(2);
    lcd.text_height(2);
    lcd.text_string("STP", column, roww, FONT_7X8, WHITE);    
}




void pb2_hit_callback (void) {
    myled2 =!myled2;
     str.append("S");
      #ifdef DEBUGLCD
        pc2.printf("%s\n", str);
      #endif
   xbee2.putc('S');
   printSTOP(3, 7); 
 //  FILE *Stop;
//   Stop=fopen("/sd/Stop.wav","r");
//   if(Stop!=NULL){
//    waver.play(Stop);
//    }else{
//    pc2.printf("Stop not open");
//   }
//    fclose(Stop);
   str.clear();
}

int main()
{
   
    bool gerror=false;

    if (GSensor.ginit()) {
        
        #ifdef DEBUGLCD
        pc2.printf("APDS-9960 initialization complete\n\r");
        #endif
    } else {
        #ifdef DEBUGLCD
        pc2.printf("Something went wrong during APDS-9960 init\n\r");
        #endif
        gerror=true;
    }

    // Start running the APDS-9960 gesture sensor engine
    if ( GSensor.enableGestureSensor(true) ) {
        #ifdef DEBUGLCD
        pc2.printf("Gesture sensor is now running\n\r");
        #endif
    } else {
        #ifdef DEBUGLCD
        pc2.printf("Something went wrong during gesture sensor init!\n\r");
        #endif
      gerror=true;

    }


  
    pb2.mode(PullUp);
    // Delay for initial pullup to take effect
    wait(.01);
    // Setup Interrupt callback function for a pb hit
    pb2.attach_deasserted(&pb2_hit_callback);
    // Start sampling pb input using interrupts
    pb2.setSampleFrequency();
    setup();
    
    while(!(GSensor.isGestureAvailable())){        
        lcd.text_width(2);
        lcd.text_height(2);  
        lcd.text_string("READY", 2, 2, FONT_12X16, WHITE);     
        lcd.text_string("FOR", 3, 3, FONT_12X16, WHITE);
        lcd.text_string("INPUT", 2, 4, FONT_12X16, WHITE);
        wait(0.5);
        lcd.cls();
        wait(0.5);
    }
    
    int temp;
    FILE *Forward;
    FILE *Backward;
    FILE *Left;
    FILE *Right;
    FILE *Error;
    FILE *Stop;

    while(gerror==false) {
        
        /*ret = GSensor.isGestureAvailable();
         pc2.printf("Is Gesture Available?: %d\n", ret);
         myled = ret;
         val = GSensor.readGesture();
         */
           
        
         if ( GSensor.isGestureAvailable()  || xbee2.readable()) {
              
            if(xbee2.readable()&& xbee2.getc()=='C'){
                temp= 67;
            }else if(GSensor.isGestureAvailable()){
                temp=GSensor.readGesture();
            }
            
            
            switch ( temp) {
                case DIR_UP:
                #ifdef DEBUGLCD
                    pc2.printf("Forward\n");
                    #endif
                     xbee2.putc('F');
                    printFWD(3, 7);
                Forward=fopen("/sd/Forward.wav","r");
                    if(Forward!=NULL){
                     waver.play(Forward);
                    }else{pc2.printf("Forward not open");}
                     fclose(Forward);
                    str.append("F");
                    break;
                case DIR_DOWN:
                    #ifdef DEBUGLCD
                    pc2.printf("Backward\n");
                    #endif
                    xbee2.putc('B');
                    printBWD(3, 7);
                   Backward=fopen("/sd/Backward.wav","r");
                    if(Backward!=NULL){
                    waver.play(Backward);
                    }else{pc2.printf("Backward not open");}
                      fclose(Backward);
                    str.append("B");
                    break;
                case DIR_LEFT:
                    #ifdef DEBUGLCD
                    pc2.printf("LEFT\n");
                    #endif
                    xbee2.putc('L');
                   printLEF(3, 7);
                    Left=fopen("/sd/Left.wav","r");
                    if(Left!=NULL){
                    waver.play(Left);
                    }else{pc2.printf("Left not open");}
                       fclose(Left);
                    str.append("L");
                    break;
                case DIR_RIGHT:
                    #ifdef DEBUGLCD
                    pc2.printf("RIGHT\n");
                    #endif
                    xbee2.putc('R');
                    printRIG(3, 7);
                    
                    Right=fopen("/sd/Right.wav","r");
                    if(Right!=NULL){
                    waver.play(Right);
                    }else{ pc2.printf("Right not open"); }
                    fclose(Right);
                     str.append("R");
                    break;
                case 67: 
                    #ifdef DEBUGLCD
                    pc2.printf("Collision\n");
                    #endif
                    printSTOP(3, 7);
                     Stop=fopen("/sd/Stop.wav","r");
                    if(Stop!=NULL){
                    waver.play(Stop);
                    }else{ pc2.printf("Stop not open");}
                   fclose(Stop);
                    str.append("C");
                    break;
                
                case DIR_NEAR:
                    #ifdef DEBUGLCD
                    pc2.printf("NEAR\n");
                    #endif
                    break;
                case DIR_FAR:
                     #ifdef DEBUGLCD
                     pc2.printf("FAR\n");
                     #endif
                     break;
                default:
                    #ifdef DEBUGLCD
                    pc2.printf("NONE\n");
                    #endif
                  printERR(0, 0);
                   Error=fopen("/sd/R2D2a.wav","r");
                  if(Error!=NULL){
                    waver.play(Error);
                    }else{ pc2.printf("Error not open");}
                      fclose(Error);
                    break;
                    
            }
        }
        


        //   wait(1);

    }
    



}

