/* ----- 4180 Final Design Project -----
	Bicycle Wheel LED Image Display
*/
#include "mbed.h"

InterruptIn hall(p28);								// This interupt is used to poll the Hall Effect IC
DigitalOut latch(p8);		
DigitalOut enable(p9);
Timer timer;										// This timer is used to time the wheel's rotation

int LEDRowNumber = 10;								// This is equal to the number of divisions the user has setup for his or her image
int cycle_time = 0;									// Global Variable for the full rotation
int rowIndex = 0;									// Index for shifting through the Image array
bool top_wheel = false;								// Variable Debug LED Circuit
int color = 0;										// Variable for shifting through colors
int j;												// For Loop index for LED debug circuit
float adj_cycle_time = 0;							// Variable used to hold "cycle_time / LEDRowNumber"

//Cycles through different colors on RGB LED
SPI spi(p5, p6, p7);

//Use SPI hardware to write color values to LED driver chip
void RGB_LED(int red, int green, int blue) {
    unsigned int low_color=0;
    unsigned int high_color=0;
    high_color=(blue<<4)|((red&0x3C0)>>6);
    low_color=(((red&0x3F)<<10)|(green));
    spi.write(high_color);
    spi.write(low_color);
    latch=1;
    latch=0;
}

//Interupt Routine used to detect when the magnet passes the Hall Effect Sensor
void intRoutine() {
    cycle_time = timer.read_ms();					//This is only called then the Hall Effect IC returns a "0"
    adj_cycle_time = cycle_time / LEDRowNumber;		//Calculates the time between sending each LED Row within the color Arrays
    timer.reset();									//Resets the Timer
    rowIndex = 0;									//Resets the Row to be sent so the image always stays in the relatively same place
    color=0;										//Resets the color Index for the LED sample wheel so the image always stays in the same place
}

int main() {
    hall.mode(PullUp);								//Initializes the PullUp Resistor for the Hall Effect Sensor
    hall.fall(&intRoutine);							//Initializes the Interrupt Routine for the Hall Effect Sensor (on falling edge)
    
	spi.format(16,0);								//Initializes the Shiftbright LED Chain
    spi.frequency(500000);
	enable=0;
    latch=0;
    wait(2);

	timer.start();									//Starts the Timer

/*//----- Color Initialization for Debug Program -----    
    int red=0;
    int green=0;
    int blue=0;
    */
    
/* //----- Spiral Pattern -----
    int red[10][10]={50,0,0,0,0,0,0,0,0,0
                     ,0,50,0,0,0,0,0,0,0,0
                     ,0,0,50,0,0,0,0,0,0,0
                     ,0,0,0,50,0,0,0,0,0,0
                     ,0,0,0,0,50,0,0,0,0,0
                     ,0,0,0,0,0,50,0,0,0,0
                     ,0,0,0,0,0,0,50,0,0,0
                     ,0,0,0,0,0,0,0,50,0,0
                     ,0,0,0,0,0,0,0,0,50,0
                     ,0,0,0,0,0,0,0,0,0,50};
    int green[10][10]={50,0,0,0,0,0,0,0,0,0
                     ,0,50,0,0,0,0,0,0,0,0
                     ,0,0,50,0,0,0,0,0,0,0
                     ,0,0,0,50,0,0,0,0,0,0
                     ,0,0,0,0,50,0,0,0,0,0
                     ,0,0,0,0,0,50,0,0,0,0
                     ,0,0,0,0,0,0,50,0,0,0
                     ,0,0,0,0,0,0,0,50,0,0
                     ,0,0,0,0,0,0,0,0,50,0
                     ,0,0,0,0,0,0,0,0,0,50};
    int blue[10][10]={50,0,0,0,0,0,0,0,0,0
                     ,0,50,0,0,0,0,0,0,0,0
                     ,0,0,50,0,0,0,0,0,0,0
                     ,0,0,0,50,0,0,0,0,0,0
                     ,0,0,0,0,50,0,0,0,0,0
                     ,0,0,0,0,0,50,0,0,0,0
                     ,0,0,0,0,0,0,50,0,0,0
                     ,0,0,0,0,0,0,0,50,0,0
                     ,0,0,0,0,0,0,0,0,50,0
                     ,0,0,0,0,0,0,0,0,0,50};
*/

//----- Pac Man -----

    int red[10][10]={50,50,50,50,50,50,50,50,50,50
                     ,50,50,50,50,50,50,50,50,50,50
                     ,50,50,50,50,50,50,50,50,50,50
                     ,50,50,50,50,50,50,50,50,50,50
                     ,50,50,50,50,50,50,0,0,50,50
                     ,50,50,50,50,50,50,50,50,50,50
                     ,0,0,0,0,0,0,0,0,0,0
                     ,0,0,0,0,0,0,0,0,0,0
                     ,50,50,50,50,50,50,50,50,50,50
                     ,50,50,50,50,50,50,50,50,50,50};
                     
    int green[10][10]={50,50,50,50,50,50,50,50,50,50
                     ,50,50,50,50,50,50,50,50,50,50
                     ,50,50,50,50,50,50,50,50,50,50
                     ,50,50,50,50,50,50,50,50,50,50
                     ,50,50,50,50,50,50,0,0,50,50
                     ,50,50,50,50,50,50,50,50,50,50
                     ,0,0,0,0,0,0,0,0,0,0
                     ,0,0,0,0,0,0,0,0,0,0
                     ,50,50,50,50,50,50,50,50,50,50
                     ,50,50,50,50,50,50,50,50,50,50};
                     
    int blue[10][10]={0,0,0,0,0,0,0,0,0,0
                     ,0,0,0,0,0,0,0,0,0,0
                     ,0,0,0,0,0,0,0,0,0,0
                     ,0,0,0,0,0,0,0,0,0,0
                     ,0,0,0,0,0,0,0,0,0,0
                     ,0,0,0,0,0,0,0,0,0,0
                     ,0,0,0,0,0,0,0,0,0,0
                     ,0,0,0,0,0,0,0,0,0,0
                     ,0,0,0,0,0,0,0,0,0,0
                     ,0,0,0,0,0,0,0,0,0,0};
                     
                     
/*// -----Blue Triangle: From Bitmap Image Program -----
    int red[36][10]={0,0,0,0,0,0,0,0,0,0,
                    0,0,0,0,0,42,42,42,42,42,
                    0,0,0,0,0,42,42,42,42,42,
                    0,0,0,0,0,0,0,42,42,42,
                    0,0,0,0,0,0,0,0,0,42,
                    0,0,0,0,0,0,0,0,0,0,
                    0,0,0,0,0,0,0,0,0,42,
                    0,0,0,0,0,0,0,0,0,42,
                    0,0,0,0,0,0,0,0,42,42,
                    0,0,0,0,0,0,0,0,42,42,
                    0,0,0,0,0,0,0,0,42,42,
                    0,0,0,0,0,0,0,0,0,42,
                    0,0,0,0,0,0,0,0,0,42,
                    0,0,0,0,0,0,0,0,0,0,
                    0,0,0,0,0,0,0,0,0,42,
                    0,0,0,0,0,0,0,42,42,42,
                    0,0,0,0,0,42,42,42,42,42,
                    0,0,0,0,0,42,42,42,42,42,
                    0,0,0,0,0,0,0,0,0,0,
                    0,0,0,0,0,0,0,0,0,0,
                    0,0,0,0,0,0,0,0,0,0,
                    0,0,0,0,0,0,0,0,0,0,
                    0,0,0,0,0,0,0,0,0,0,
                    0,0,0,0,0,0,0,0,0,0,
                    0,0,0,0,0,0,0,0,0,0,
                    0,0,0,0,0,0,0,0,0,0,
                    0,0,0,0,0,0,0,0,0,0,
                    0,0,0,0,0,0,0,0,0,0,
                    0,0,0,0,0,0,0,0,0,0,
                    0,0,0,0,0,0,0,0,0,0,
                    0,0,0,0,0,0,0,0,0,0,
                    0,0,0,0,0,0,0,0,0,0,
                    0,0,0,0,0,0,0,0,0,0,
                    0,0,0,0,0,0,0,0,0,0,
                    0,0,0,0,0,0,0,0,0,0,
                    0,0,0,0,0,0,0,0,0,0}; 
    
int green[36][10]={0,0,0,0,42,42,42,42,42,42,
                    0,0,0,0,0,0,0,0,0,0,
                    0,0,0,0,0,0,0,0,0,0,
                    0,0,0,0,0,0,0,0,0,0,
                    0,0,0,0,0,0,0,0,0,0,
                    0,0,0,0,0,0,0,0,0,0,
                    0,0,0,0,0,0,0,0,0,0,
                    0,0,0,0,0,0,0,0,0,0,
                    0,0,0,0,0,0,0,0,0,0,
                    0,0,0,0,0,0,0,0,0,0,
                    0,0,0,0,0,0,0,0,0,0,
                    0,0,0,0,0,0,0,0,0,0,
                    0,0,0,0,0,0,0,0,0,0,
                    0,0,0,0,0,0,0,0,0,0,
                    0,0,0,0,0,0,0,0,0,0,
                    0,0,0,0,0,0,0,0,0,0,
                    0,0,0,0,0,0,0,0,0,0,
                    0,0,0,0,0,0,0,0,0,0,
                    0,0,0,0,42,42,42,42,42,42,
                    0,0,0,0,42,42,42,42,42,42,
                    0,0,0,0,42,42,42,42,42,42,
                    0,0,0,0,42,42,42,42,42,42,
                    0,0,0,0,42,42,42,42,42,42,
                    0,0,0,0,42,42,42,42,42,42,
                    0,0,0,0,42,42,42,42,42,42,
                    0,0,0,0,0,42,42,42,42,42,
                    0,0,0,0,0,0,0,42,42,42,
                    0,0,0,0,0,0,0,0,42,42,
                    0,0,0,0,0,0,0,42,42,42,
                    0,0,0,0,0,42,42,42,42,42,
                    0,0,0,0,0,42,42,42,42,42,
                    0,0,0,0,42,42,42,42,42,42,
                    0,0,0,0,42,42,42,42,42,42,
                    0,0,0,0,42,42,42,42,42,42,
                    0,0,0,0,42,42,42,42,42,42,
                    0,0,0,0,42,42,42,42,42,42};
    
    int blue[36][10]={42,42,42,42,0,0,0,0,0,0,
                    42,42,42,42,42,0,0,0,0,0,
                    42,42,42,42,42,0,0,0,0,0,
                    42,42,42,42,42,42,42,0,0,0,
                    42,42,42,42,42,42,42,42,42,0,
                    42,42,42,42,42,42,42,42,42,42,
                    42,42,42,42,42,42,42,42,42,0,
                    42,42,42,42,42,42,42,42,42,0,
                    42,42,42,42,42,42,42,42,0,0,
                    42,42,42,42,42,42,42,42,0,0,
                    42,42,42,42,42,42,42,42,0,0,
                    42,42,42,42,42,42,42,42,42,0,
                    42,42,42,42,42,42,42,42,42,0,
                    42,42,42,42,42,42,42,42,42,42,
                    42,42,42,42,42,42,42,42,42,0,
                    42,42,42,42,42,42,42,0,0,0,
                    42,42,42,42,42,0,0,0,0,0,
                    42,42,42,42,42,0,0,0,0,0,
                    42,42,42,42,0,0,0,0,0,0,
                    42,42,42,42,0,0,0,0,0,0,
                    42,42,42,42,0,0,0,0,0,0,
                    42,42,42,42,0,0,0,0,0,0,
                    42,42,42,42,0,0,0,0,0,0,
                    42,42,42,42,0,0,0,0,0,0,
                    42,42,42,42,0,0,0,0,0,0,
                    42,42,42,42,42,0,0,0,0,0,
                    42,42,42,42,42,42,42,0,0,0,
                    42,42,42,42,42,42,42,42,0,0,
                    42,42,42,42,42,42,42,0,0,0,
                    42,42,42,42,42,0,0,0,0,0,
                    42,42,42,42,42,0,0,0,0,0,
                    42,42,42,42,0,0,0,0,0,0,
                    42,42,42,42,0,0,0,0,0,0,
                    42,42,42,42,0,0,0,0,0,0,
                    42,42,42,42,0,0,0,0,0,0,
                    42,42,42,42,0,0,0,0,0,0};
*/
    while(1) {
        //led1 = hall;		// Used for Debugging the Hall Effect IC
        //led2 = !hall;		// Used for Debugging the Hall Effect IC

		//----- Code for Cycling through a 2D Picture Array -----
        wait_ms(adj_cycle_time);
        for(int i=9;i>=0;i--){  //If we update without any waiting, the LEDs change colors super fast, and you won't notice the shifting LEDs
            RGB_LED( red[rowIndex][i], green[rowIndex][i], blue[rowIndex][i]);
        }
        rowIndex++;
        if(rowIndex>=LEDRowNumber){
            rowIndex = 0;
        }
        
        
       /* //----- Debug Code: Rainbow Pattern ------ (Pre 2D Color Array)
	   wait_ms(adj_cycle_time);
       top_wheel = true;
       if (top_wheel && (color == 0)) {
            // Red, Color 0
            //printf("RED RED RED\r\n");
            red = 50;
            blue = 0;
            green = 0;
            for(j = 0; j < 10; j++)
                RGB_LED(red, green, blue);
            top_wheel = false;
            color++;
        }
        if (top_wheel && (color == 1)) {
            //printf("ORANGE ORANGE ORANGE\r\n");
            // Orange, Color 1
            red = 50;
            blue = 0;
            green = 25;
            for(j = 0; j < 10; j++)
                RGB_LED(red, green, blue);
            top_wheel = false;
            color++;
        }
        if (top_wheel && (color == 2)) {
            //printf("YELLOW YELLOW YELLOW\r\n");
            // Yellow, Color 2
            red = 50;
            blue = 0;
            green = 50;
            for(j = 0; j < 10; j++)
                RGB_LED(red, green, blue);
            top_wheel = false;
            color++;
        }
       if (top_wheel && (color == 3)) {
            //printf("GREEN GREEN GREEN\r\n");
            // Green, Color 3
            red = 0;
            blue = 0;
            green = 50;
            for(j = 0; j < 10; j++)
                RGB_LED(red, green, blue);
            top_wheel = false;
            color++;
        }
        if (top_wheel && (color == 4)) {
            //printf("CYAN CYAN CYAN\r\n");
            // Cyan, Color 4
            red = 0;
            blue = 50;
            green = 50;
            for(j = 0; j < 10; j++)
                RGB_LED(red, green, blue);
            top_wheel = false;
            color++;
        }
        if (top_wheel && (color == 5)) {   
            //printf("BLUE BLUE BLUE\r\n"); 
            // Blue, Color 5
            red = 0;
            blue = 50;
            green = 0;
            for(j = 0; j < 10; j++)
                RGB_LED(red, green, blue);
            top_wheel = false;
            color++;
        }
        if (top_wheel && (color == 6)) {
            //printf("PURPLE PURPLE PURPLE\r\n");
            //Purple, Color 6
            red = 50;
            blue = 50;
            green = 0;
            for(j = 0; j < 10; j++)
                RGB_LED(red, green, blue);
            top_wheel = false;
            color = 0;
        }
        */
    }
}