#include "Operator.h"

static const float pi2 = 6.283185307179586476925286766559f;

FMOperator::FMOperator()
{
    attack = 0.0f;
    delay = 0.0f;
    sustain = 0.0f;
    sustainRate = 1.0f;
    release = 0.0f;

    frequencyMultiple = 1.0f;
    totalLevel = 1.0f;
    
    startTime = 0.0;
    releaseTime = 0.0;
    baseFrequency = 1.0f;
}

FMOperator::FMOperator(Timer *tm, AOTTrigon *t)
{
    attack = 0.0f;
    delay = 0.0f;
    sustain = 0.0f;
    sustainRate = 1.0f;
    release = 0.0f;

    frequencyMultiple = 1.0f;
    totalLevel = 1.0f;
    
    tri = t;
    master = tm;
    startTime = 0.0;
    releaseTime = 0.0;
    baseFrequency = 1.0f;
}

float FMOperator::calculate(float fmIn) {
    if (startTime == 0.0) return 0.0f;
    float pos = (pi2 * baseFrequency * frequencyMultiple);
    double nt = (master->read_us() / 1000000.0) - startTime;
    return tri->sin(fmIn + (float)(pos * nt));
}

void FMOperator::attackNote(float freq) {
    baseFrequency = freq;
    startTime = master->read_us() / 1000000.0;
}

void FMOperator::releaseNote() {
    startTime = 0.0;
    releaseTime = master->read_us() / 1000000.0;
}