#include "MIDI.h"

char sysexData[128];

void getMIDIMessage()
{
    unsigned char st = midis.getc();
    switch(st >> 4) {
        case 0x8:
            midiNoteOff(st & 0xf, midis.getc(), midis.getc());
            break;
        case 0x9:
            midiNoteOn(st & 0xf, midis.getc(), midis.getc());
            break;
        case 0xa:
            midiPolyphonicKeyPressure(st & 0xf, midis.getc(), midis.getc());
            break;
        case 0xb:
            char b2 = midis.getc();
            if (b2 >= 120) {
                midiChannelMode(st & 0xf, b2, midis.getc());
            } else {
                midiControlChange(st & 0xf, b2, midis.getc());
            }
            break;
        case 0xc:
            midiProgramChange(st & 0xf, midis.getc());
            break;
        case 0xd:
            midiChannelPressure(st & 0xf, midis.getc());
            break;
        case 0xe:
            char LSB = midis.getc();
            char MSB = midis.getc();
            midiPitchBend(st & 0xf, ((LSB << 7) | (MSB << 7)) + 8192);
            break;
        case 0xf:
            int t2 = st & 0xf;
            if (t2 <= 7) {
                getMIDISystemCommonMessage(t2);
            } else {
                midiSystemRealtimeMessage(st);
            }
            break;
    }
}

void getMIDISystemCommonMessage(char t2)
{
    switch(t2) {
        case 0:
            //もう面倒臭いから128byteのバッファに適当に放り込んでおこう
            sysexData[0] = 0xf0;
            int i = 1;
            char d = 0;
            do {
                d = midis.getc();
                sysexData[i]=d;
                i++;
            } while(d != 0xf7);

            break;
        case 1:
            midis.getc();
            break;
        case 2:
            midis.getc();
            midis.getc();
            break;
        case 3:
            midis.getc();
            break;
        case 4:
            break;
        case 5:
            break;
        case 6:
            break;
        case 7:
            //どうしろと
            break;
    }
}

void midiSystemRealtimeMessage(char mes)
{

}


void midiNoteOn(char ch, char note, char vel)
{
    if (vel==0) {
        globalrelease((ch<<8)|note);
    } else {
        globalattack((ch<<8)|note,vel);
    }
}

void midiNoteOff(char ch, char note, char vel)
{
    globalrelease((ch<<8)|note);
}

void midiPolyphonicKeyPressure(char ch, char note, char vel)
{

}

void midiControlChange(char ch, char ctrl, char data)
{

}

void midiChannelMode(char ch, char ctrl, char data)
{

}

void midiProgramChange(char ch, char prg)
{

}

void midiChannelPressure(char ch, char pres)
{

}

void midiPitchBend(char ch, short pb)
{

}

void midiSystemExclusiveMessage()
{

}