#include "Main.h"

Ticker sampler;
MCP4922 output(PA_7, PA_5, PA_8);

AOTTrigon t;
const int operators = 32;
FMOperator op[operators];

Timer master;
Serial midis(USBTX,USBRX);

const double smpps = 40000.0;
const double smpus = 1000000.0 / smpps;

double ntime = 0.0;
volatile double freq = 0;

float out = 0.0f;

void tick_sampling();
void midiReceived();

int state[operators];

int main()
{
    //DAC setting
    output.referenceMode(MCP4922::DAC_A, MCP4922::REF_UNBUFFERED);
    output.gainMode(MCP4922::DAC_A, MCP4922::GAIN_1X);
    output.powerMode(MCP4922::DAC_A, MCP4922::POWER_NORMAL);
    output.referenceMode(MCP4922::DAC_B, MCP4922::REF_UNBUFFERED);
    output.gainMode(MCP4922::DAC_B, MCP4922::GAIN_1X);
    output.powerMode(MCP4922::DAC_B, MCP4922::POWER_NORMAL);

    //MIDI Serial setting
    midis.baud(256000);
    midis.format();

    //for(int i = 0; i < operators; i++) new(op + i) FMOperator(&master, &t);
    midis.attach(&midiReceived);

    master.start();
    while(true) {
        ntime = master.read_us()/1000000.0;
        float out = 0;
        int oc=0;
        for(int i=0;i<operators;i++) {
            if (state[i]!=0) {
                oc++;
                out += t.sin(M_PI * 2.0 * ntime * getNoteNumberFrequency(state[i]&0x7f));
            }
        }
        output.write(MCP4922::DAC_A,out/oc+0.5);
    }
}

void midiReceived()
{
    getMIDIMessage();
    while(midis.readable()) midis.getc();
}

void setDebugFrequency(double f)
{
    freq = f;
}

void globalattack(unsigned short st,char vel) {
    int to=0;
    for(int i = 0; i < operators; i++) {
        if (state[i]==0) to=i;
    }
    state[to] = st | vel << 16;
}

void globalrelease(unsigned short st) {
    for(int i = 0; i < operators; i++) {
        if ((state[i]&0xffff)==st) state[i]=0;
    }
}