#pragma once
#include "mbed.h"
#include "AQM0802A.h"
#include "FMOperator.h"
#include "MIDIUtil.h"
#include "FMAlgorithm.h"

class MIDIChannel
{
public:
    MIDIChannel();
    MIDIChannel(AQM0802A *l, Timer *tm, AOTTrigon *tri);
    ~MIDIChannel();

    inline void setModulationMSB(char msb) {
        modulation = msb;
    }
    inline void setModulationLSB(char lsb) {
        //modulation = lsb | (modulation & 0x3f80);
    }
    inline void setPortamentoTime(char val) {
        portamentoTime = val;
    }
    inline void setPortamentoSwitch(bool val) {
        portamento = val;
    }
    inline void setVolume(char val) {
        volume = val;
    }
    inline void setExpression(char val) {
        expression = val;
    }
    inline void setPanpot(char val) {
        panpot = val;
    }
    inline void startHold1() {
        hold1 = true;
    }
    inline void endHold1() {
        hold1 = false;
    }

    void setDataEntryMSB(char msb);
    void setDataEntryLSB(char lsb);
    void setNRPNMSB(char msb);
    void setNRPNLSB(char lsb);
    void setRPNMSB(char msb);
    void setRPNLSB(char lsb);
    void allSoundOff();
    void allNoteOff();
    void noteOn(char key, char vel, double time);
    void noteOff(char key, double time);

private:
    enum DataState {
        Undefined = 0,
        RPNDoubleData,
        RPNSingleData,
        RPNNoData,
        NRPNDoubleData,
        NRPNSingleData,
        NRPNNoData,
    };
    char prkey;
    char dataEntryMSB;
    char dataEntryLSB;
    char nrpnMSB;
    char nrpnLSB;
    char rpnMSB;
    char rpnLSB;
    DataState state;
    char modulation;
    char portamentoTime;
    bool portamento;
    char volume;
    char panpot;
    char expression;
    bool hold1;
    FMAlgorithm *algo;
    AQM0802A *lcd;
    Timer *timer;
    AOTTrigon *trigon;
    
    FunctionPointer nrpnStateSetter;
    FunctionPointer nrpnStateProcessor;
    
    void processRPNFunction();
    void setNRPNFunctions();
    void nrpnUndefined();
    void setStateNRPNUndefined();
    void nrpnAlgorithm();
    void setStateNRPNAlgorithm();
    void nrpnOperator();
    void setStateNRPNOperator();
};
