#include "MIDIChannel.h"

MIDIChannel::MIDIChannel()
{

}

MIDIChannel::MIDIChannel(AQM0802A *l, Timer *tm, AOTTrigon *tri)
{
    modulation = 0;
    portamentoTime = 0;
    portamento = false;
    volume = 127;
    panpot = 64;
    expression = 127;
    hold1 = false;
    dataEntryMSB = 0;
    dataEntryLSB = 0;
    nrpnMSB = 0;
    nrpnLSB = 0;
    rpnMSB = 0;
    rpnLSB = 0;
    algo = NULL;
    state = Undefined;
    lcd = l;
    nrpnStateSetter.attach(this, &MIDIChannel::setStateNRPNUndefined);
    nrpnStateProcessor.attach(this, &MIDIChannel::nrpnUndefined);
}

MIDIChannel::~MIDIChannel()
{
    if (algo != NULL) delete algo;
}

void MIDIChannel::noteOn(char key, char vel, double time) {
    prkey = key;
    algo->noteOn(getNoteNumberFrequency(prkey), time);
}

void MIDIChannel::noteOff(char key, double time) {
    if (prkey != key) return;
    algo->noteOff(time);
}

void MIDIChannel::setDataEntryMSB(char msb)
{
    dataEntryMSB = msb;
    if (state == NRPNSingleData || state == RPNSingleData) nrpnStateProcessor.call();
}

void MIDIChannel::setDataEntryLSB(char lsb)
{
    dataEntryLSB = lsb;
    if (state == NRPNDoubleData || state == RPNDoubleData) nrpnStateProcessor.call();
}

void MIDIChannel::setNRPNMSB(char msb)
{
    nrpnMSB = msb;
    setNRPNFunctions();
}

void MIDIChannel::setNRPNLSB(char lsb)
{
    nrpnLSB = lsb;
    nrpnStateSetter.call();
    if (state == NRPNNoData) nrpnStateProcessor.call();
}

void MIDIChannel::setRPNMSB(char msb)
{
    rpnMSB = msb;
    if (msb == 0x7f) {
        state = RPNNoData;
    } else {
        state = RPNSingleData;
    }
}

void MIDIChannel::setRPNLSB(char lsb)
{
    rpnLSB = lsb;
    if (state == RPNNoData) processRPNFunction();
}

void MIDIChannel::allSoundOff()
{
}

void MIDIChannel::allNoteOff()
{
}

void MIDIChannel::processRPNFunction()
{
    switch(rpnMSB) {
        case 0x00:
            //LSB 0~2全部実装できないですから
            break;
        case 0x7f:
            if (rpnLSB == 0x7f) {
                rpnMSB = 0;
                rpnLSB = 0;
                nrpnMSB = 0;
                nrpnLSB = 0;
            }
            lcd->cls();
            lcd->printf("RPN/NRPN\nNULL");
            break;
    }
    state = Undefined;
}

