#include "FMAlgorithm.h"

FMAlgorithm::FMAlgorithm()
{
    opcount = 0;
    cncount = 0;
    cni = 0;
    operators = NULL;
    connections = NULL;
}

FMAlgorithm::FMAlgorithm(int opc, int cnc, Timer *tm, AOTTrigon *tri)
{
    opcount = opc;
    cncount = cnc;
    operators = new FMOperator*[opcount];
    for(int i = 0; i < opcount; i++) operators[i] = new FMOperator(tm, tri);
    connections = new FMAlgorithmConnection[cncount];
}

FMAlgorithm::~FMAlgorithm()
{
    if (operators != NULL) {
        for(int i = 0; i < opcount; i++) delete operators[i];
        delete[] operators;
    }
    if (connections != NULL) delete[] connections;
}

void FMAlgorithm::setConnection(int t, int s)
{
    if (cni >= cncount) return;
    connections[cni].target = t;
    connections[cni].source = s;
    connections[cni].allocated = true;
    cni++;
}

void FMAlgorithm::setConnectionIndex(int id) { 
    if (id >= cncount) return;
    cni = id;
}

void FMAlgorithm::enableCurrentConnection() {
    if (cni >= cncount) return;
    connections[cni].allocated = true;
}

void FMAlgorithm::disableCurrentConnection() {
    if (cni >= cncount) return;
    connections[cni].allocated = false;
}

void FMAlgorithm::noteOn(float freq, double time) {
    for(int i = 0; i < opcount; i++) {
        if (operators[i] != NULL) operators[i]->attackNote(freq, time);
    }
}

void FMAlgorithm::noteOff(double time) {
    for(int i = 0; i < opcount; i++) {
        if (operators[i] != NULL) operators[i]->releaseNote(time);
    }
}

float FMAlgorithm::calculate() {
    return calculate(0);
}

float FMAlgorithm::calculate(int opn) {
    float sum = 0;
    for(int i = 0; i < cncount; i++) {
        if (connections[i].allocated && connections[i].target == opn) {
            sum += calculate(connections[i].source);
        }
    }
    return operators[opn]->calculate(sum);
}