#pragma once

extern float notenumfreqs[];

inline float getNoteNumberFrequency(int nn) {
    return notenumfreqs[nn];
}

enum MIDIMessageType{
    NoteOn,
    NoteOff,
    PolyphonicKeyPressure,
    ControlChange,
    ProgramChange,
    ChannelPressure,
    PitchBend,
    ChannelMode,
    SystemCommon,
    SystemRealtime,
};

typedef struct {
    MIDIMessageType type;
    char channel;
    union {
        char note;
        char control;
        char program;
        char LSB;
    };
    union {
        char velocity;
        char pressure;
        char data;
        char MSB;
    };
} MidiMessage;