#include "MIDIChannel.h"

void MIDIChannel::setNRPNFunctions()
{
    switch(nrpnMSB) {
        case 0x10:
            nrpnStateSetter.attach(this, &MIDIChannel::setStateNRPNAlgorithm);
            nrpnStateProcessor.attach(this, &MIDIChannel::nrpnAlgorithm);
            break;
        case 0x20:
            nrpnStateSetter.attach(this, &MIDIChannel::setStateNRPNOperator);
            nrpnStateProcessor.attach(this, &MIDIChannel::nrpnOperator);
            break;
        default:
            nrpnStateSetter.attach(this, &MIDIChannel::setStateNRPNUndefined);
            nrpnStateProcessor.attach(this, &MIDIChannel::nrpnUndefined);
            break;
    }
}

// -- xxh xxh Undefined

void MIDIChannel::nrpnUndefined()
{

}

void MIDIChannel::setStateNRPNUndefined()
{

}

// -- 10h xxh Algorithm

void MIDIChannel::nrpnAlgorithm()
{
    switch(nrpnLSB) {
        case 0x01:
            if (algo != NULL) delete algo;
            algo = new FMAlgorithm(dataEntryMSB, dataEntryLSB, timer, trigon);
            break;
        case 0x02:
            //FMOperatorをFMAlgorithm持ちにしたので廃止
            break;
        case 0x03:
            algo->setConnectionIndex(dataEntryMSB);
            break;
        case 0x04:
            algo->setConnection(dataEntryMSB, dataEntryLSB);
            break;
        case 0x05:
            algo->disableCurrentConnection();
            break;
        case 0x06:
            algo->enableCurrentConnection();
            break;
    }
}

void MIDIChannel::setStateNRPNAlgorithm()
{
    switch(nrpnLSB) {
        case 0x01:
        case 0x02:
        case 0x04:
            state = NRPNDoubleData;
            break;
        case 0x03:
            state = NRPNSingleData;
            break;
        case 0x05:
        case 0x06:
            state = NRPNNoData;
            break;
    }
}

// -- 20h xxh Operator

void MIDIChannel::nrpnOperator()
{
    switch(nrpnLSB) {
        case 0x01:
            algo->getOperator(dataEntryMSB)->setAttack(dataEntryLSB);
            break;
        case 0x02:
            algo->getOperator(dataEntryMSB)->setDecay(dataEntryLSB);
            break;
        case 0x03:
            algo->getOperator(dataEntryMSB)->setSustain(dataEntryLSB);
            break;
        case 0x04:
            algo->getOperator(dataEntryMSB)->setSustainRate(dataEntryLSB);
            break;
        case 0x05:
            algo->getOperator(dataEntryMSB)->setRelease(dataEntryLSB);
            break;
        case 0x06:
            algo->getOperator(dataEntryMSB)->setFrequencyMultiple(dataEntryLSB);
            break;
        case 0x07:
            algo->getOperator(dataEntryMSB)->setFrequencyMultipleFloating(dataEntryLSB);
            break;
        case 0x08:
            algo->getOperator(dataEntryMSB)->setTotalLevel(dataEntryLSB);
            break;
        case 0x09:
            algo->getOperator(dataEntryMSB)->setFeedback(dataEntryLSB);
            break;
    }
}

void MIDIChannel::setStateNRPNOperator()
{
    state = NRPNDoubleData;
}
