#pragma once
#include "mbed.h"
#include "AQM0802A.h"
#include "AOTTrigon.h"
#include "FMOperator.h"
#include "MIDIUtil.h"
#include "MIDIChannel.h"
#include <new>

class FMOscillator
{
public:
    FMOscillator();
    FMOscillator(Timer *tim, Serial *ser, AOTTrigon *tri, I2C *i2clcd);
    ~FMOscillator();
private:
    Timer *master;
    Serial *serial;
    AOTTrigon *trigon;
    AQM0802A *lcd;
    MIDIChannel **channels;
    int opcount;
    
    void getMIDIMessage();
    void midiReceived();
    void getMIDISystemCommonMessage(char t2);
    void midiSystemRealtimeMessage(char mes);
    void midiNoteOn(char ch, char note, char vel);
    void midiNoteOff(char ch, char note, char vel);
    void midiPolyphonicKeyPressure(char ch, char note, char vel);
    void midiControlChange(char ch, char ctrl, char data);
    void midiChannelMode(char ch, char ctrl, char data);
    void midiProgramChange(char ch, char prg);
    void midiChannelPressure(char ch, char pres);
    void midiPitchBend(char ch, short pb);
    void midiSystemExclusiveMessage();
};
