#pragma once
#include "mbed.h"
#include "AOTTrigon.h"


class FMOperator {

public:
    FMOperator();
    FMOperator(Timer *tm, AOTTrigon *t);
    float calculate(float fmIn);
    void attackNote(float freq, double time);
    void releaseNote(double time);
    
    inline void setAttack(char x) {
        attack = 0.0078125f * x;
    }
    inline void setDecay(char x) {
        decay = 0.0078125f * x;
    }
    inline void setSustain(char x) {
        sustain = 0.0078125f * (x + 1);
    }
    inline void setSustainRate(char x) {
        sustainRate = 0.0078125f * x;
    }
    inline void setRelease(char x) {
        release = 0.0078125f * x;
    }
    
    inline void setFrequencyMultiple(char x) {
        frequencyMultiple = x;
    }
    
    inline void setFrequencyMultipleFloating(char x) {
        frequencyMultiple *= 0.0078125f * (x + 1);
    }
    
    inline void setTotalLevel(char x) {
        totalLevel = 0.0078125f * (x + 1);
    }
    
    inline void setFeedback(char x) {
        feedback = 0.0078125f * x;
    } 

private:
    Timer *master;
    AOTTrigon *tri;
    //時間だけdouble確保
    double startTime;
    double releaseTime;
    bool released;
    double baseFrequency;
    
    float attack;
    float decay;
    float sustain;
    float sustainRate;
    float release;
    float frequencyMultiple;
    float totalLevel;
    float modulation;
    float feedback;
    float prev;
    
    float getEnvelopeRate(double t);
    float getEnvelopeReleaseRate(double rlst, float orate);
    
    inline float getCeilingFloatRate(char cr) {
        return 0.0078125f * (cr + 1);
    }
};