#pragma once
#include "mbed.h"
#include "FMOperator.h"
#include "AOTTrigon.h"

class FMAlgorithmConnection
{
public:
    FMAlgorithmConnection() {
        target = 0;
        source = 0;
        allocated = false;
    }
    int target;
    int source;
    bool allocated;
};

class FMAlgorithm
{
public:
    FMAlgorithm();
    FMAlgorithm(int opc, int cnc, Timer *tm, AOTTrigon *tri);
    ~FMAlgorithm();
    FMOperator* getOperator(int idx) {
        if (idx < opcount) return operators[idx];
        return operators[idx];
    }
    void setConnection(int t, int s);
    void setConnectionIndex(int id);
    void enableCurrentConnection();
    void disableCurrentConnection();
    float calculate();
    void noteOn(float freq, double time);
    void noteOff(double time);
    
private:
    int opcount;
    int cncount;
    int cni;
    FMOperator **operators;
    FMAlgorithmConnection *connections;

    float calculate(int opn);
};
