#pragma once

#include "math.h"

//double precision version

class LUTTrigonometric
{
public:
    LUTTrigonometric(int division = 256);
    
    inline double sin(double x);
    inline double cos(double x);
    inline double tan(double x);
    
private:
    double *table;
    int div;
    const double pi;
    double rate;
};

double LUTTrigonometric::sin(double x) {
    return table[(int)(x * rate) % div];
}


double LUTTrigonometric::cos(double x) {
    return table[(int)((x + pi / 2.0) * rate) % div];
}

double LUTTrigonometric::tan(double x) {
    return sin(x) / cos(x);
}

//single precision version

class LUTSingleTrigonometric
{
public:
    LUTSingleTrigonometric(int division = 256);
    
    inline float sin(float x);
    inline float cos(float x);
    inline float tan(float x);
    
private:
    float *table;
    int div;
    const float pi;
    float rate;
};

float LUTSingleTrigonometric::sin(float x) {
    return table[(int)(x * rate) % div];
}


float LUTSingleTrigonometric::cos(float x) {
    return table[(int)((x + pi / 2.0) * rate) % div];
}

float LUTSingleTrigonometric::tan(float x) {
    return sin(x) / cos(x);
}
