#include "LUTTrigonometric.h"

LUTTrigonometric::LUTTrigonometric(int division): pi(3.1415926535897932384626433832795) {
    div = division;
    rate = division / pi / 2.0;
    table = new double[div];
    for(int i = 0; i < div; i++) table[i] = ::sin(pi * 2.0 / rate * i);
}

LUTTrigonometric::~LUTTrigonometric() {
    delete[] table;
}


LUTSingleTrigonometric::LUTSingleTrigonometric(int division): pi(3.1415926535f) {
    div = division;
    rate = division / pi / 2.0f;
    table = new float[div];
    for(int i = 0; i < div; i++) table[i] = (float)::sin(pi * 2.0f / rate * i);
}

LUTSingleTrigonometric::~LUTSingleTrigonometric() {
    delete[] table;
}