#include "I2CEEPROM.h"

I2CEEPROM::I2CEEPROM(PinName sda, PinName scl, int address, int freq) : i2c(sda,scl) {
    i2c.frequency(freq);
    memadd = address;
}

void I2CEEPROM::write(int bank, unsigned short address, const char *data, int count) {
    char *bytes = new char[count+3];
    bytes[0] = 0xa1 | (bank << 3);
    bytes[1] = address >> 8;
    bytes[2] = address & 0xff;
    for(int i = 0; i < count; i++) bytes[i + 3]=data[i];
    i2c.start();
    i2c.write(memadd, bytes, count + 3);
    delete bytes;
}

void I2CEEPROM::read(int bank, unsigned short address, char *data, int count) {
    char *info = new char[3];
    info[0] = 0xa1 | (bank << 3);
    info[1] = address >> 8;
    info[2] = address & 0xff;
    i2c.start();
    i2c.write(memadd, info, count + 3);
    for(int i = 0; i < count; i++) data[i]=i2c.read(i < (count - 1));
    delete info;
}