#pragma once
#include "math.h"
#include "mbed.h"

/** AOTTrigon class
 * AOT計算によって三角関数の計算を高速化します。
 */
class AOTTrigon
{
public:
    AOTTrigon(int c) {
        pi = 3.14159265358979323846264;
        rate = 40.743665431525205956834243423364;
        for(int i = 0; i < 256; i++)
            t_sin[i] = sin(i / 256.0 * (pi * 2.0));
    }

    double fsin(double x) {
        return x * rate;//t_sin[((int)(x * rate)) % 256];
    }

    double fcos(double x) {
        return fsin(x + pi / 2.0f);
    }

    double ftan(double x) {
        return fsin(x) / fcos(x);
    }

private:
    double t_sin[256];
    double rate;
    double pi;
};

