#include "mbed.h"
#include "SoftSerial.h"
#include "ESP8266.h"

Serial *logger;
SoftSerial *ser;
ESP8266 *esp;

int main() {    
    logger = new Serial(USBTX, USBRX);
    ser = new SoftSerial(dp18, dp17);
    
    ser->baud(9600);
    logger->baud(9600);
    
    esp = new ESP8266(ser);
    esp->setLogger(logger);
        
    if(!esp->config()) {
        logger->printf("Configuration failed.\r\n");
        return -1;
    }
    
    if(!esp->connect("ArtesWare HQ Main", "kt621221")) {
        logger->printf("Connection failed.\r\n");
        return -1;
    }
    
    esp->connectionStatus();
    
    delete esp;
    delete logger;
    delete ser;
    
    return 0;
    
}
