/**
 * Use ESP-8266 (called ESP-WROOM-02 in Japan) from LPC1114
 * LPC1114 has only 1 Hardware UART so this class uses SoftSerial to 
 * communicate with ESP-8266.
 * I wrote like this class for Arduino then partially ported to mbed.
 *
 * 2016/05/13
 * By Kazuo Tsubaki
 **/
 
#ifndef __ESP8266__
#define __ESP8266__

#include <mbed.h>
#include "SoftSerial.h"

class ESP8266 {
public:

    // Constructor
    ESP8266(SoftSerial *s);
    ~ESP8266();
    
    // Example for configuring ESP
    bool config();
    // Use Serial to logging
    void setLogger(Serial *log);
    
    // Connect to WiFi AP
    bool connect(char *ssid, char *password);
    // Send command to ESP-8266 (see AT command list of the module)
    void sendRequest(char *req);
    // Read resultant response of AT command. Needs some waits to read after AT command.
    char *readResponse();
    
    // AT
    bool nop();
    // AT+GMR
    void version();
    // AT+RST
    bool reset();
    // AT+CWMODE=n    n= 1:Station Mode, 2:AP Mode, 3:Station Mode + AP Mode
    bool mode(int mode);
    // AT+CIPMUX=n    n= 0:Single, 1=Multi
    bool connectionMode(int connMode);
    // AT+CIPSTA?
    void connectionStatus();
    
private:

    void sendCmd();
    void getReply();
    bool _ok();
    
private:

    char cmdbuffer[266];
    char replybuffer[1024];
    SoftSerial *stream;
    int replycount, timeout, getcount;
    Timer t;
    Serial *logger;
};    


#endif
