#include "ESP8266.h"

#define LOG_DEBUG(s)   if(logger != NULL) { logger->printf("%s\r\n", s); };

ESP8266::ESP8266(SoftSerial *s) {
    stream = s;
}

ESP8266::~ESP8266() {
}

void ESP8266::setLogger(Serial *l) {
    logger = l;
}

bool ESP8266::_ok() {
    return (strstr(replybuffer, "OK\r\n") != NULL);
}

bool ESP8266::nop() {
    sendRequest("AT\r\n");
    timeout=20;
    getReply();
    return _ok();
}

bool ESP8266::reset() {
    LOG_DEBUG("Reset & get Firmware");
    sendRequest("AT+RST\r\n");
    timeout=200;
    getReply();
    LOG_DEBUG(replybuffer);
    return _ok();
}

void ESP8266::version() {
    LOG_DEBUG("Get Version");
    sendRequest("AT+GMR\r\n");
    timeout=200;
    getReply();
    LOG_DEBUG(replybuffer);
}

// 1=Station, 2=AP, 3=BOTH, default=Station
bool ESP8266::mode(int mode) {
    char cmd[255];
    sprintf(cmd, "AT+CWMODE=%d\r\n", mode);
    sendRequest(cmd);
    timeout=60;
    getReply();
    LOG_DEBUG(replybuffer);
    return _ok();
}

// 0=Single, 1=Multi
bool ESP8266::connectionMode(int connMode) {
    char cmd[255];
    sprintf(cmd, "AT+CIPMUX=%d\r\n", connMode);
    sendRequest(cmd);
    timeout=80;
    getReply();
    LOG_DEBUG(replybuffer);
    return _ok();
}

void ESP8266::connectionStatus() {
    LOG_DEBUG("Get Connection Status");
    sendRequest("AT+CIPSTA?\r\n");
    timeout=100;
    getReply();
    LOG_DEBUG(replybuffer);
}

bool ESP8266::config() {
    timeout=1000; getcount=600;
    wait(1);
    
    if(!nop())
        return false;
    wait(1);
         
    version(); 
    wait(3);
 
    if(!mode(1))
        return false;
    wait(2);
 
    if(!connectionMode(1))
        return false;   
    wait(2);
    
    return true;
}

bool ESP8266::connect(char *ssid, char *password) {
    char cmd[256];
    LOG_DEBUG("Connecting");
    strcpy(cmd, "AT+CWJAP=\"");
    strcat(cmd, ssid);
    strcat(cmd, "\",\"");
    strcat(cmd, password);
    strcat(cmd, "\"\r\n");
    LOG_DEBUG(cmd);
    sendRequest(cmd);
    timeout=10000;
    getReply();    
    
    wait(5);
    
    return _ok();
}

void ESP8266::sendRequest(char *req) {
    strcpy(cmdbuffer, req);
    sendCmd();
}

char *ESP8266::readResponse() {
    getReply();
    return replybuffer;
}


void ESP8266::sendCmd() {
    stream->printf("%s", cmdbuffer);
}

void ESP8266::getReply() {
    memset(replybuffer, '\0', sizeof(replybuffer));
    replycount = 0;
    t.reset(); t.start();
    while(t.read_ms() < timeout && replycount < getcount) {
        if(stream->readable()) {
            replybuffer[replycount] = stream->getc();
            replycount++;
        }
    }
}

