/**
 * Simple class to handle I2C 16 chars x 2 rows Character LCD
 * By K. Tsubaki
 * Date: 2016/04/24
 * Tested with: mbed LPC1114
 * Usage: 
 *        mbed <---> LCD
 *        dp5  <---> SDA
 *        dp27 <---> SCL
 *        VIN  <---> +V
 *        GND  <---> GND
 **/
#ifndef __AQM1602XA__

#include "mbed.h"

#define AQM1602XA_ADDR          (0x3E << 1)

class AQM1602XA {
    private:
        I2C         wire;
        char        address;
        
        void initialize(void);
        void writeCommand(char cmd);
        void writeData(char data);
    public:
        /**
         * Constructor - default device address is 0x3E
         **/
        AQM1602XA(PinName sda, PinName scl, char slave_adr = AQM1602XA_ADDR);
        /**
         * print characters on the LCD
         * params: row (0 or 1)
         *         str - string to show on the LCD. The length is up to 16 characters
         **/
        void printString(int row, char *str);
};

#endif
