// Twitter Mbed with WiFly RN-XV
// 
// coded by Kazushi Mukaiyama (http://www.kazushi.info/)
// refer to cookbook of WiFly(https://mbed.org/cookbook/wifly)
// refer to GingaX's notebook (http://www31.atwiki.jp/gingax/pages/63.html)

#include "mbed.h"
#include "PowerControl/PowerControl.h"
#include "PowerControl/EthernetPowerControl.h"
#include "WiflyInterface.h"
#include "HTTPClient.h"
#include "sjis_utf16.h"
#include "s_Lcd.h"

#define countof(x) ( sizeof(x) / sizeof(x[0]) )

#define SSID "your_ssid"
#define PASS "your_pass"

#define HTTP_URI "http://api.supertweet.net/1.1/statuses/user_timeline.json?screen_name=pla3c&count=1"
#define HTTP_USER "your_id"
#define HTTP_PASS "your_pass"

#define INTERVAL_SEC 90.0

//#define _DEBUG

WiflyInterface wifly(p13, p14, p15, p16, SSID, PASS, WPA); // TX, RX, reset, connection_status
HTTPClient http;
DigitalOut led1(LED1), led2(LED2);
#ifdef _DEBUG
    Serial pc(USBTX, USBRX);
#endif

char buf[512];

unsigned char kstatus = 0;
bool estate = false;
unsigned char unibuf[4];
unsigned char codes[512];

unsigned short convert(unsigned short utf){
    unsigned short sjis = NULL; 
    for(int i=0; i<countof(sjis2utf16)/2; i++){
        if(utf==sjis2utf16[i*2+1]){
            sjis = sjis2utf16[i*2];
            break;
        }
    }
    return sjis;
}

bool parseCode(const unsigned char* s){
    unsigned int i = 0;
    unsigned char c;
    
    bool em = false;
    while((c = *s++) != '\0') {
        if(estate && kstatus==4){ // 1st digit of utf-16
            unibuf[3] = c;
            char *endptr;
            unsigned short code = convert(strtol((char*)unibuf, &endptr, 16));
            codes[i] = code>>8 & 0xFF;
            i++;
            codes[i] = code & 0xFF;
            i++;
            if(code==0x8149) em = true;
    #ifdef _DEBUG
            pc.printf("%s, %x\r\n", unibuf, code);
    #endif
            kstatus = 0;
            estate = false;
        } else if(estate && kstatus==3){ // 2nd digit of utf-16
            unibuf[2] = c;
            kstatus = 4;
        } else if(estate && kstatus==2){ // 3rd digit of utf-16
            unibuf[1] = c;
            kstatus = 3;
        } else if(estate && kstatus==1){ // 4th digit of utf-16
            unibuf[0] = c;
            kstatus = 2;
        } else if(estate && c=='u'){
            kstatus = 1;
        } else if(estate && !c=='u'){
            drawc(c);
            kstatus = 0;
            estate = false;
        } else if(c=='\\'){ // escape code
            estate = true;
        } else { // 4x8font
            codes[i] = c;
            i++;
            if(c=='!') em = true;
        }
    }
    
    codes[i]= '\0';
    
    return em;
}

void drawString(const unsigned char *s){
    unsigned char c;
    while((c = *s++) != '\0') drawc(c);
}

int connect(){
    char localip[20];
    
    wifly.init(); //Use DHCP
    while (!wifly.connect());
    
#ifdef _DEBUG
    pc.printf("ip %s\r\n", wifly.getIPAddress());
#endif

    sprintf(localip, "ip %s", wifly.getIPAddress());
    drawString((unsigned char*)localip); newline();
        
    return 0;
}

void parseBuffer () {
    led2 = 1;
    
    // parse buffer    
    char* c = strtok(buf, "\"");
         while(c!=NULL){
            char* c = strtok(NULL, "\"");
            char key[4];
            sprintf(key, "%.4s", c);
            if(strcmp(key, "text")==0){
                c = strtok(NULL, "\"");
                c = strtok(NULL, "\"");
#ifdef _DEBUG
                pc.printf("%s\r\n", c);
#endif
                bool emergency = parseCode((unsigned char*)c);
                if(emergency) color(0xf800); else color(0x001f);
                cls();
                color(0xffff);
                drawString(codes); newline();
                if(emergency) bmp(0,80,1); else bmp(0,80,0); // comment out if you don't use on-memory images
                break;
            }
        }
    
    led2 = 0;
}

int main() {
    int r;
    char* msg;
    led1 = 0;
    
    PHY_PowerDown();
    Peripheral_PowerDown(0x7D7F6FE1);    

#ifdef _DEBUG
    pc.baud(9600);
#endif
    
    s_Lcdinit();
    
    color(0x001f);
    cls();
    color(0xffff);

    msg = "connect";
    drawString((unsigned char*)msg); newline();
    r = connect();
    if(r<0){
        NVIC_SystemReset();
    }
    
    wait_ms(1000);
    
    msg = "start twitter";
    drawString((unsigned char*)msg); newline();

    http.basicAuth(HTTP_USER, HTTP_PASS);

    wait_ms(1000);
    
    while(1) {
        led1 = !led1; wait_ms(500); led1 = !led1; // blink
        
        int ret = http.get(HTTP_URI, buf, 351); // out put only 40 zenkaku characters
        if(!ret){
            parseBuffer();
        }else{
            sprintf((char*)codes, "Error - ret = %d - HTTP return code = %d", ret, http.getHTTPResponseCode());
            color(0x001f);
            cls();
            color(0xffff);
            drawString(codes); newline();
            if(ret==8){
                drawString("disconnect..."); newline();
                wifly.disconnect();
                wifly.init();
                drawString("reconnect..."); newline();
                while (!wifly.connect());
                drawString("done"); newline();
            }
        }
        
#ifdef _DEBUG
        if(!ret){
            pc.printf("Page fetched successfully - read %d characters\r\n", strlen(buf));
            pc.printf("Result: %s\r\n", buf);
        }else{
            pc.printf("Error - ret = %d - HTTP return code = %d\r\n", ret, http.getHTTPResponseCode());
        }
#endif
        wait(INTERVAL_SEC);
   }
}
