#include "dbg.h"
#include "mbed.h"
#include "GSwifi.h"

#ifdef GS_USE_SMTP

int GSwifi::mail (Host &host, const char *to, const char *from, const char *subject, const char *mesg, const char *user, const char *pwd) {
    int ret = -1;
    int cid;

    if (! _connect || _status != GSSTAT_READY) return -1;

    if (host.getIp().isNull()) {
        if (getHostByName(host)) {
            if (getHostByName(host)) return -1;
        }
    }
    if (host.getPort() == 0) {
        host.setPort(25);
    }

    cid = open(host, GSPROT_TCP);
    if (cid < 0) return -1;
    DBG("cid %d\r\n", cid);

    if (wait_smtp(cid ,220)) goto exit;

    // send request
    send(cid, "EHLO gainspan\r\n", 15);
    wait_ms(100);
    if (wait_smtp(cid ,250)) goto exit;

    if (user && pwd) {
        // smtp auth
        char tmp[80], buf[100];
        int len;
        snprintf(tmp, sizeof(tmp), "%s%c%s%c%s", user, 0, user, 0, pwd);
        len = strlen(user) * 2 + strlen(pwd) + 2;
        base64encode(tmp, len, buf, sizeof(buf));
        send(cid, "AUTH PLAIN ", 11);
        send(cid, buf, strlen(buf));
        send(cid, "\r\n", 2);
        if (wait_smtp(cid ,235)) goto quit;
    }
 
    send(cid, "MAIL FROM: ", 11);
    send(cid, from, strlen(from));
    send(cid, "\r\n", 2);
    if (wait_smtp(cid ,250)) goto quit;
 
    send(cid, "RCPT TO: ", 9);
    send(cid, to, strlen(to));
    send(cid, "\r\n", 2);
    if (wait_smtp(cid ,250)) goto quit;
 
    send(cid, "DATA\r\n", 6);
    if (wait_smtp(cid ,354)) goto quit;
 
    // mail data
    send(cid, mesg, strlen(mesg));
    send(cid, "\r\n.\r\n", 5);
    if (wait_smtp(cid ,250)) goto quit;
    ret = 0;
 
    LOG("From: %s To: %s %d\r\n", from, to, strlen(mesg));

quit:
    send(cid, "QUIT\r\n", 6);
    if (wait_smtp(cid ,221)) goto exit;
 
exit:
    close(cid);
    return ret;
}

int GSwifi::wait_smtp (int cid, int code) {
    Timer timeout;
    int i, n, len = 0;
    char buf[200], data[100];

    // wait responce
    timeout.start();
    while (timeout.read_ms() < SMTP_TIMEOUT) {
        wait_ms(100);
        poll();
        n = recv(cid, buf, sizeof(buf));
        for (i = 0; i < n; i ++) {
            if (buf[i] == '\r') continue;
            if (buf[i] == '\n') {
                if (len == 0) continue;
                goto next;
            } else
            if (len < sizeof(data) - 1) {
                data[len] = buf[i];
                len ++;
            }
        }
    }
next:
    data[len] = 0;
    len = 0;
    DBG("smtp: %s\r\n", data);
    timeout.stop();
 
    // check return code
    i = atoi(data);
    DBG("smtp status %d\r\n", i);
    if (i == code) return 0;
 
    return -1;
}

#endif
