/**
 * ...
 * @author Kazushi Mukaiyama
 */
 
#include "AkitaSM.h"
#include "mbed.h"

#define AKITA_AICTRL0   0x0C // Current song number / Song change
#define AKITA_AICTRL1   0x0D // Number of songs on MMC
#define AKITA_AICTRL2   0x0E // Number of songs on MMC (VS1103b)
#define AKITA_AICTRL3   0x0F // Play mode

AkitaSM::AkitaSM(int addr, PinName sda, PinName scl)
    : _i2c(sda, scl) {
    
    _addr = addr<<1;

    // Set up the i2c interface
    //_i2c.frequency(1000000);
}

void AkitaSM::play(int index, bool loop)
{
    char p = 0;
    if(loop) p = 1; else p = 3;
    _cmd[0] = AKITA_AICTRL3;
    _cmd[1] = 0;
    _cmd[2] = p << 1;
    _i2c.write(_addr, _cmd, 3);
    wait(0.01);
    int n = 0x8000 + index;
    _cmd[0] = AKITA_AICTRL0;
    _cmd[1] = (n >> 8) & 0xFF;
    _cmd[2] = n & 0xFF;
    _i2c.write(_addr, _cmd, 3);
    //_cmd[0] = index & 0xFF;
    //_i2c.write(_addr, _cmd, 1);
}

void AkitaSM::stop()
{
    _cmd[0] = AKITA_AICTRL3;
    _cmd[1] = 0;
    _cmd[2] = 1<<4;
    _i2c.write(_addr, _cmd, 3);
}

void AkitaSM::control(char r, int cmd)
{
    //r is resistor 0x00-0x0f
    _cmd[0] = r;
    _cmd[1] = (cmd >> 8) & 0xFF;
    _cmd[2] = cmd & 0xFF;
    _i2c.write(_addr, _cmd, 3);
}

char* AkitaSM::isPlaying()
{
    //_i2c.read(_addr, _cmd, 4);
    _i2c.read(_addr, _cmd, 4);
    return _cmd;
}
