/**
 * ...
 * @author Kazushi Mukaiyama
 */

#ifndef MBED_AKITASM_H
#define MBED_AKITASM_H
 
#include "mbed.h"

/** An interface for the Akita MP3 Sound Module
 *
 */

class AkitaSM  {
public:

    /** Create an AkitaSM interface, connected to the specified pins
     *
     * @param sda I2C data line pin
     * @param scl I2C clock line pin
     */
    AkitaSM(int addr, PinName sda, PinName scl);
    
    void play(int index, bool loop=false);
    void stop();
    void control(char r, int cmd);
    char* isPlaying();
    
private:
    I2C _i2c;
    int _addr;
    char _cmd[4];
};

#endif
