/*The MIT License (MIT)

Copyright (c) <2015> <Kazumichi Aoki>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/



#include "mbed.h"
#include "PID.h"
#include "math.h"
#include "SB1602E.h"
#include "QEI.h"
#include "rtos.h"
//GPIO initilaize
AnalogIn THAI(dp4);
PwmOut   out(dp1);
DigitalOut ledR(dp28),ledG(dp26),ledB(dp14);
InterruptIn RunPB(dp13);
Serial pc(dp16, dp15); // tx, rx


/* PID constant initialize Kc, Ti, Td, interval */
#define P 0.1 //propotional band
#define I 1.5 //Integral
#define D 1.0 //Devide
#define RATE 0.1 //update time sec
#define InitialSP 30.0 // Boot Setpoint initial temeprature
PID TIC(P, I, D, RATE);

/*LCD I2C pin initialize */
char *init_massage = "Hello!";
SB1602E lcd(dp5, dp27, init_massage);  //  SDA, SCL
/*QEI initialize */
#define ROTATE_PER_REVOLUTIONS  24
QEI wheel(dp17, dp18, NC, ROTATE_PER_REVOLUTIONS, QEI::X2_ENCODING);

//Initial
float temp_sv_input = InitialSP, waittime,OV_LL,ticout,qei,Bias;
bool Run(false);
double temp_pv,temp_cal;
int rtostime;

/*PB control*/
void runmode()
{
    Run = !Run;
}

void cal_temp(void const *argument)
{
    while(1) {
        /*input for change to 0 to 100% range by 30C to 120C */
        /*Temperature setpoint low high range */
#define RangeSPL 30.0 //Celcius low side temperature 
        temp_sv_input = wheel.getPulses() / 20.0 + RangeSPL;
        if (temp_sv_input <= RangeSPL) {
            temp_sv_input = RangeSPL;
#define RangeSPH 100.0 //Celcius high side temperature
        } else if (temp_sv_input >= RangeSPH) {
            temp_sv_input = RangeSPH;
        }

        /*six order polynomial calculation value
        Thermister pull up resiter 560R
        Thermister B value 3380K
        Thermister Resistance 10K ohm at 25C
        This NTC is NCP18XH103F03RB muRata
        */
        temp_cal = THAI.read() * 3.3;
        temp_pv =-0.7964*pow(temp_cal,6.0) - 2.5431*pow(temp_cal,5.0) +63.605*pow(temp_cal,4.0) - 274.1*pow(temp_cal,3.0) + 522.57*pow(temp_cal,2.0) - 539.26*temp_cal + 405.76;

        /*LCD Display section */
        /*LCD Display section */
        lcd.printf(0, "SP %.1f", temp_sv_input);
        lcd.printf(0, "PV %.1f\n", temp_pv);
        lcd.printf(1, "OUT %.2f", out.read() * 100);
        lcd.printf(1, "PB %s\n", Run);
        /*Tenperature indicater */
        /* 1.5C high temperature */
        if (Run == true) {
            if ((temp_pv - temp_sv_input) >= 1.5) {
                ledR = 0;
                ledG = 1;
                ledB = 1;
                /* 1.5C low temperature */
            } else if ((temp_sv_input - temp_pv ) >= 1.5 ) {
                ledR = 1;
                ledG = 1;
                ledB = 0;
            } else {
                /* control green */
                ledR = 1;
                ledG = 0;
                ledB = 1;
            }
        } else {
            ledR = 1;
            ledG = 1;
            ledB = 1;
        }
        Thread::wait(rtostime * 2);
    }
}


int main()
{
    RunPB.mode(PullDown);
#define LCDCont 0x32 //LCD contrast set from 00 to 3f 64resolution defult set is 32step
    lcd.contrast(LCDCont);
    out.period(0.02);
    RunPB.rise(&runmode);
    Thread thread(cal_temp);
    rtostime = RATE * 1000;
    while (1) {
        /*PID control*/
#define SV_LL 0.0 //PID setpoint % value for lo limit
#define SV_HL 100.0 //PID setpoint % value for high limit
        TIC.setInputLimits(SV_LL, SV_HL);
#define OV_LL 0.0 //PID calcurate output value 0.0 = 0%
#define OV_HL 100.0 //PID calcurate output value 1.0 = 100%
        if (Run == true) {
            TIC.setOutputLimits(OV_LL, OV_HL);
            TIC.setSetPoint(temp_sv_input);
            TIC.setProcessValue(temp_pv);
            TIC.setBias(Bias); //control output bias
            TIC.setMode(1);
            out = TIC.compute() /100;
            TIC.setInterval(RATE);
        } else if (Run == false) {
            TIC.setMode(0);
            TIC.reset();
            out = 0.0;
        }
        Thread::wait(rtostime);

    }
}