#ifndef __BLE_STATE_SERVICE_H__
#define __BLE_STATE_SERVICE_H__

class STATEService {
public:
    const static uint16_t STATE_SERVICE_UUID              = 0xA004;
    const static uint16_t AUTH_STATE_CHARACTERISTIC_UUID = 0xA041;
    const static uint16_t POWER_STATE_CHARACTERISTIC_UUID = 0xA042;
    const static uint16_t USB_STATE_CHARACTERISTIC_UUID = 0xA043;

    STATEService(BLEDevice &_ble, char initialValueForAUTHCharacteristic
    , char initialValueForPOWERCharacteristic, char initialValueForUSBCharacteristic) :
        ble(_ble), authState(AUTH_STATE_CHARACTERISTIC_UUID, &initialValueForUSBCharacteristic),
        powerState(POWER_STATE_CHARACTERISTIC_UUID, &initialValueForUSBCharacteristic),
        usbState(USB_STATE_CHARACTERISTIC_UUID, &initialValueForUSBCharacteristic)
    {
        GattCharacteristic *charTable[] = {&authState,&powerState,&usbState};
        GattService         stateService(STATE_SERVICE_UUID, charTable, sizeof(charTable) / sizeof(GattCharacteristic *));
        ble.addService(stateService);
    }

    GattAttribute::Handle_t getAuthValueHandle() const
    {
        return authState.getValueHandle();
    }

    GattAttribute::Handle_t getPowerValueHandle() const
    {
        return powerState.getValueHandle();
    }

    GattAttribute::Handle_t getUsbValueHandle() const
    {
        return usbState.getValueHandle();
    }
    
    /**
     *サービスの値を更新する
     *http://flogics.com/wp/2015/03/mbed-%E3%81%A7-ble-%E3%81%AE%E3%82%A2%E3%83%97%E3%83%AA%E3%82%92%E6%9B%B8%E3%81%84%E3%81%A6%E3%81%BF%E3%82%8B2/
     *http://bril-tech.blogspot.jp/2014/06/bluetoothsmartmbed-4.html
     */
    void authStateUpdate(char val) {
        char counterValue = val;
        ble.updateCharacteristicValue(getAuthValueHandle(),
                (uint8_t *) &counterValue,
                sizeof(counterValue));
    }
    
    /**
     *サービスの値を更新する
     *http://flogics.com/wp/2015/03/mbed-%E3%81%A7-ble-%E3%81%AE%E3%82%A2%E3%83%97%E3%83%AA%E3%82%92%E6%9B%B8%E3%81%84%E3%81%A6%E3%81%BF%E3%82%8B2/
     *http://bril-tech.blogspot.jp/2014/06/bluetoothsmartmbed-4.html
     */
    void powerStateUpdate(char val) {
        char counterValue = val;
        ble.updateCharacteristicValue(getPowerValueHandle(),
                (uint8_t *) &counterValue,
                sizeof(counterValue));
    }
    
    /**
     *サービスの値を更新する
     *http://flogics.com/wp/2015/03/mbed-%E3%81%A7-ble-%E3%81%AE%E3%82%A2%E3%83%97%E3%83%AA%E3%82%92%E6%9B%B8%E3%81%84%E3%81%A6%E3%81%BF%E3%82%8B2/
     *http://bril-tech.blogspot.jp/2014/06/bluetoothsmartmbed-4.html
     */
    void usbStateUpdate(char val) {
        char counterValue = val;
        ble.updateCharacteristicValue(getUsbValueHandle(),
                (uint8_t *) &counterValue,
                sizeof(counterValue));
    }

private:
    BLEDevice                         &ble;
    ReadOnlyGattCharacteristic<char> authState;
    ReadOnlyGattCharacteristic<char> powerState;
    ReadOnlyGattCharacteristic<char> usbState;
};

#endif /* #ifndef __BLE_STATE_SERVICE_H__ */
