/* mbed Microcontroller Library
 * Copyright (c) 2006-2013 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __BLE_USB_SERVICE_H__
#define __BLE_USB_SERVICE_H__

class USBService {
public:
    const static uint16_t USB_SERVICE_UUID              = 0xA003;
    const static uint16_t USB_STATE_CHARACTERISTIC_UUID = 0xA031;

    USBService(BLEDevice &_ble, bool initialValueForUSBCharacteristic) :
        ble(_ble), usbState(USB_STATE_CHARACTERISTIC_UUID, &initialValueForUSBCharacteristic)
    {
        GattCharacteristic *charTable[] = {&usbState};
        GattService         usbService(USB_SERVICE_UUID, charTable, sizeof(charTable) / sizeof(GattCharacteristic *));
        ble.addService(usbService);
    }

    GattAttribute::Handle_t getValueHandle() const
    {
        return usbState.getValueHandle();
    }

private:
    BLEDevice                         &ble;
    WriteOnlyGattCharacteristic<bool> usbState;
};

#endif /* #ifndef __BLE_USB_SERVICE_H__ */
