#ifndef __BLE_PIN_SERVICE_H__
#define __BLE_PIN_SERVICE_H__

class PINService {
public:
    const static uint16_t PIN_SERVICE_UUID              = 0xA002;
    const static uint16_t PIN_STATE_CHARACTERISTIC_UUID = 0xA021;

    PINService(BLEDevice &_ble, char initialValueForPINCharacteristic[]) :
        ble(_ble), pinState(PIN_STATE_CHARACTERISTIC_UUID, &initialValueForPINCharacteristic[0])
    {
        GattCharacteristic *charTable[] = {&pinState};
        GattService         pinService(PIN_SERVICE_UUID, charTable, sizeof(charTable) / sizeof(GattCharacteristic *));
        ble.addService(pinService);
    }

    GattAttribute::Handle_t getValueHandle() const
    {
        return pinState.getValueHandle();
    }

private:
    BLEDevice                         &ble;
    WriteOnlyArrayGattCharacteristic<char,6> pinState;
};

#endif /* #ifndef __BLE_PIN_SERVICE_H__ */
