#ifndef __BLE_INIT_SERVICE_H__
#define __BLE_INIT_SERVICE_H__

class INITService {
public:
    const static uint16_t INIT_SERVICE_UUID              = 0xA001;
    const static uint16_t SET_STATE_CHARACTERISTIC_UUID = 0xA011;
    const static uint16_t GET_STATE_CHARACTERISTIC_UUID = 0xA012;

    INITService(BLEDevice &_ble, char initialValueForSETCharacteristic[], char initialValueForGETCharacteristic) :
        ble(_ble), setState(SET_STATE_CHARACTERISTIC_UUID, &initialValueForSETCharacteristic[0]),//配列の最初のアドレスを指定する
        getState(GET_STATE_CHARACTERISTIC_UUID, &initialValueForGETCharacteristic)
    {
        GattCharacteristic *charTable[] = {&setState,&getState};
        GattService         initService(INIT_SERVICE_UUID, charTable, sizeof(charTable) / sizeof(GattCharacteristic *));
        ble.addService(initService);
    }

    GattAttribute::Handle_t getValueHandle() const
    {
        return setState.getValueHandle();
    }
    
    GattAttribute::Handle_t getGETValueHandle() const
    {
        return getState.getValueHandle();
    }
    
    /**
     *サービスの値を更新する
     *http://flogics.com/wp/2015/03/mbed-%E3%81%A7-ble-%E3%81%AE%E3%82%A2%E3%83%97%E3%83%AA%E3%82%92%E6%9B%B8%E3%81%84%E3%81%A6%E3%81%BF%E3%82%8B2/
     *http://bril-tech.blogspot.jp/2014/06/bluetoothsmartmbed-4.html
     */
    void stateUpdate(char val) {
        ble.updateCharacteristicValue(getGETValueHandle(),
                (uint8_t *) &val,
                sizeof(val));
    }

private:
    BLEDevice                         &ble;
    WriteOnlyArrayGattCharacteristic<char,6> setState;
    ReadOnlyGattCharacteristic<char> getState;
};

#endif /* #ifndef __BLE_INIT_SERVICE_H__ */
