/* mbed Microcontroller Library
 * Copyright (c) 2006-2013 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#ifndef MAIN_H
#define MAIN_H

#define WIGO               1
#define WIFI_DIPCORTEX     2
#define MBED_BOARD_EXAMPLE 3
#define UNDEFINED          4

#define MY_BOARD MBED_BOARD_EXAMPLE

// use this defines in AP_SECURITY
#define NONE 0
#define WEP  1
#define WPA  2
#define WPA2 3

// use smart config
#define USE_SMART_CONFIG 0

 // Default SSID Settings
#define AP_KEY       "Testbed-0"
#define AP_SECURITY  WPA2            // WPA2 must be enabled for use with iPhone or Android phone hotspot!
#define SSID         "Testbed-0"

#define USE_DHCP      1
#define USE_STATIC_IP 2
 
// Modify the following settings as necessary for your Wi-Fi Network setup:
#define IP_ALLOC_METHOD USE_DHCP        // for DHCP assigned IP address
//#define IP_ALLOC_METHOD USE_STATIC_IP // for static IP address
 
#define STATIC_IP_OCT1 10
#define STATIC_IP_OCT2 10
#define STATIC_IP_OCT3 0
#define STATIC_IP_OCT4 100
 
#define STATIC_GW_OCT1 10
#define STATIC_GW_OCT2 10
#define STATIC_GW_OCT3 0
#define STATIC_GW_OCT4 254

void init();

#endif
