//////////////////////////////////////////////////////////
// Kaz Technology Lab.                                  //
// 2012.11.29                                           //
// PROJECT: ECHONET Light over WebSocket                //
//////////////////////////////////////////////////////////

#include "mbed.h"
#include "EthernetInterface.h"
#include "Websocket.h"
#include "MbedJSONValue.h"

#define BASE_URL "ws://129.60.20.254:8080/ws/sensors/rw"

// illuminance control
PwmOut ilc(p21);

// response control flag
int sendFlag = 0;

// transaction ID
int transactionId = 0;

// Super Class Device Object
string operatingStatus = "";
string operatingStatus_prev = "";
string classCode = "GeneralLighting";
string instanceCode = "L0001";
    
// General Lighing Class Object
int illuminanceLevel = 100;
int illuminanceLevel_prev = 100;

int main() {
    char buf[200];
    Timer timer;
    MbedJSONValue json_r, json_s;
    
    //PWM frequency
    ilc.period_ms(5); 
    // setup Ethernet Interface
    EthernetInterface eth;
//    eth.init(); //Use DHCP
    eth.init("192.168.111.21", "255.255.255.0", "192.168.111.1");
    eth.connect();
    printf("IP Address is %s\n\r", eth.getIPAddress());

    //WebSocket instance
    Websocket ws(BASE_URL);
      
    //attempt to make a connection 
    while(! ws.connect()) {
        printf("cannot connect WebSocket, retrying...\r\n");
        wait(2);
    }
    printf("WebSocket connected!\r\n");
             
    //INFO timer
    timer.start();

    while(true) {
        // send INFO
        if (timer.read() > 10) {   // device sends  INFO every 10 seconds
            json_s["TransactionID"] = transactionId;
            json_s["ESV"] = "INFO";
            json_s["ClassCode"] = classCode;
            json_s["InstanceCode"] = instanceCode;
            json_s["OperatingStatus"] = operatingStatus;
            
            // power consumption = V * I * duty cycle (in mW)
            json_s["PowerConsumption"] = int(12.0 * 40.0 * ilc.read());
            transactionId++;
            
            printf("json_s: %s\r\n", json_s.serialize());
            ws.send((char*)json_s.serialize().c_str());
            timer.reset();
        }
        
        if (ws.read(buf)) {
            parse(json_r, buf);
            printf("json: %s\r\n", json_r.serialize());

            if(strcmp(json_r["ESV"].get<std::string>().c_str(), "Get") == 0){
                if(json_r.hasMember("OperatingStatus")){
                    json_s["OperatingStatus"] = operatingStatus;
                }
                else if(json_r.hasMember("IlluminanceLevel")){
                    json_s["IlluminanceLevel"] = illuminanceLevel;
                }
                else if(json_r.hasMember("PowerConsumption")){
                    // power consumption = V * I * duty cycle (in mW)
                    json_s["PowerConsumption"] = int(12.0 * 40.0 * ilc.read());
                }
                json_s["ESV"] = "Get_Res";
                sendFlag = 1;
            }

            if(strcmp(json_r["ESV"].get<std::string>().c_str(), "SetI") == 0){
                if(json_r.hasMember("OperatingStatus")){
                    operatingStatus_prev = operatingStatus;
                    operatingStatus = json_r["OperatingStatus"].get<std::string>().c_str();
                    if(strcmp(operatingStatus_prev.c_str(), operatingStatus.c_str()) == 0){
                        if(strcmp(operatingStatus.c_str(), "ON") == 0){
                            ilc = illuminanceLevel / 100.0;
                        }
                        if(strcmp(operatingStatus.c_str(), "OFF") == 0){
                            ilc = 0.0;
                        }
                    }
                }
                else if(json_r.hasMember("IlluminanceLevel")){
                    illuminanceLevel_prev = illuminanceLevel;
                    illuminanceLevel = json_r["IlluminanceLevel"].get<int>();
                    if(illuminanceLevel_prev != illuminanceLevel){
                        ilc = illuminanceLevel / 100.0;
                    }        
                }
                sendFlag = 0;
            }

            if(strcmp(json_r["ESV"].get<std::string>().c_str(), "SetC") == 0){
                printf("ESV: SetC\r\n");
                if(json_r.hasMember("OperatingStatus")){
                    operatingStatus_prev = operatingStatus;
                    operatingStatus = json_r["OperatingStatus"].get<std::string>();
                    if(strcmp(operatingStatus_prev.c_str(), operatingStatus.c_str()) != 0){
                        if(strcmp(operatingStatus.c_str(), "ON") == 0){
                            printf("operationgStatus --> ON\r\n");
                            json_s["OperatingStatus"] = "ON";
                            if(illuminanceLevel_prev == 0) {
                              illuminanceLevel = 100;
                              illuminanceLevel_prev = 100;
                            }
                            ilc = illuminanceLevel / 100.0;
                        }
                        if(strcmp(operatingStatus.c_str(), "OFF") == 0){
                            json_s["OperatingStatus"] = "OFF";
                            printf("operatingStatus --> OFF\r\n");
                            ilc = 0.0;
                        }
                    }
                }
                if(json_r.hasMember("IlluminanceLevel")){
                    illuminanceLevel_prev = illuminanceLevel;
                    illuminanceLevel = json_r["IlluminanceLevel"].get<int>();
                    if(illuminanceLevel_prev != illuminanceLevel){
                        printf("illminanceLevel --> %d\r\n", illuminanceLevel);
                        ilc = illuminanceLevel / 100.0;
                        json_s["IlluminanceLevel"] = illuminanceLevel;
                    }        
                }
                json_s["ESV"] = "SetC_Res";
                sendFlag = 1;
            }

            if(strcmp(json_r["ESV"].get<std::string>().c_str(), "SetGet") == 0){
                if(json_r.hasMember("OperatingStatus")){
                    operatingStatus_prev = operatingStatus;
                    operatingStatus = json_r["OperatingStatus"].get<std::string>();
                    if(strcmp(operatingStatus_prev.c_str(), operatingStatus.c_str()) == 0){
                        if(strcmp(operatingStatus.c_str(), "ON") == 0){
                            ilc = illuminanceLevel / 100.0;
                        }
                        if(strcmp(operatingStatus.c_str(), "OFF") == 0){
                            ilc = 0.0;
                        }
                    }
                }
                if(json_r.hasMember("IlluminanceLevel")){
                    illuminanceLevel_prev = illuminanceLevel;
                    illuminanceLevel = json_r["IlluminanceLevel"].get<int>();
                    if(illuminanceLevel_prev != illuminanceLevel){
                        ilc = illuminanceLevel / 100.0;
                    }        
                }
                json_s["ESV"] = "SetGet_Res";
                json_s["PowerConsumption"] = int(12.0 * 40.0 * ilc.read());
                sendFlag = 1;
            }

            if(sendFlag == 1){
                json_s["TransactionID"] = transactionId;
                json_s["ClassCode"] = classCode;
                json_s["InstanceCode"] = instanceCode;
            
                printf("json_s: %s\r\n", json_s.serialize());
                ws.send((char*)json_s.serialize().c_str());
                sendFlag = 0;
                transactionId++;
            }
        }

        if (! ws.is_connected()) {
            printf("disconnected\r\n");
            exit(0);
        }
    }
}