/* Program Example 12.7: Ethernet write
                                         */
#include "mbed.h"                                      
#include "TextLCD.h"
#include <Ethernet.h>

DigitalOut myled(LED1);
TextLCD lcd(p21, p22, p23, p24, p25, p26, p27); // rs, rw, e, d4, d5, d6, d7
Ethernet eth;

char data[]={0xAA,0xBB, 0xCC, 0xDD, 0xEE, 0xFF};// Define the data values
char mac[] ={0x22, 0x22, 0x22, 0x22, 0x22, 0x22};
/*char source_IP[] ={0xC0,0xC0,0xC0,0xC0};//source IP = 192.192.192.192
char dest_IP[] = {0x6F,0x6F,0x6F,0x6F};//destination IP = 111.111.111.111*/
int incoming_size = 0 ;
int buffered_size = 1;

int main() {
    lcd.cls();
    wait(1); // Needed after startup.
    myled = 0;
    //eth.address(mac);//get mac address of mbed
    while (eth.link()) {}//check whether Ethernet link is online
    lcd.printf("online\n");
    while(1){
        wait(1);
        incoming_size = eth.receive();
        while (incoming_size==0) {incoming_size = eth.receive();} //force to receive packet
        lcd.cls();
        lcd.printf("Received %u"  ,incoming_size);
        lcd.printf("\n bytes packet");
        wait(2);
        char received[incoming_size];
        buffered_size = eth.read(received, incoming_size);                                            
        myled = 1;
        lcd.cls();
        lcd.printf("Dest:  %02X:%02X:%02X:%02X:%02X:%02X\n",
                    received[0], received[1], received[2], received[3], received[4], received[5]);
        wait(2); 
        for (int i=0;i<6;i++){//change MAC address of the packet
            received[i]=mac[i];
        }
        lcd.cls();
        lcd.printf("Changed:  %02X:%02X:%02X:%02X:%02X:%02X\n",
                    received[0], received[1], received[2], received[3], received[4], received[5]);
        wait(2);
        lcd.cls();
        if (buffered_size == incoming_size){
            lcd.printf("sending...");
            for (int i=0;i<10;i++) {
                eth.write(received, buffered_size);
                eth.send();
                wait(0.3);
            }
            lcd.cls();
            lcd.printf("Packet has been sent!");
         }
    }//end of infinite loop   
}//end of main

