#include "mbed.h"
#include "DHT/DHT.h"
#include <string>

using namespace std;

DHT sensor(A2,DHT22); 
Serial pc(SERIAL_TX,SERIAL_RX);
Serial xbee(A0,A1);

void getTemperatueHumidity(){
    int err;
    pc.printf("\r\nStarting to gather temperature and humidity......\n");
    pc.printf("\r\n******************\r\n");
    wait(1); // wait 1 second for device stable status
    while (1) {
 
        err = sensor.readData();
        if (err == 0) {
            pc.printf("Temperature is %4.2f C \r\n",sensor.ReadTemperature(CELCIUS));
            pc.printf("Temperature is %4.2f F \r\n",sensor.ReadTemperature(FARENHEIT));
            pc.printf("Temperature is %4.2f K \r\n",sensor.ReadTemperature(KELVIN));
            pc.printf("Humidity is %4.2f \r\n",sensor.ReadHumidity());
     
            xbee.printf("Temperature is %4.2f C \r\n",sensor.ReadTemperature(CELCIUS));
            xbee.printf("Temperature is %4.2f F \r\n",sensor.ReadTemperature(FARENHEIT));
            xbee.printf("Temperature is %4.2f K \r\n",sensor.ReadTemperature(KELVIN));
            xbee.printf("Humidity is %4.2f \r\n",sensor.ReadHumidity());
     
            return;
        } else {
            pc.printf("\r\nErr %i \n",err);
            xbee.printf("\r\nErr %i \n",err);
        }
        wait(5);
    }
}

void printInit(){
     xbee.printf("Awaiting User Command....\n");
}

int main() {
   
    char a;
    printInit();
    while(1){
        a = xbee.getc();        
        if(a == 'T'){
            getTemperatueHumidity();
            a = NULL; 
            printInit();     
        }
        
        if( a == 'G'){
            //GPS function
            a = NULL;
            printInit();    
        }      
    }
}

