#include "mbed.h"
 
#define MESS_LEN    100     // maximum message length
#define MAX_STR     20
#define STR_LEN     40 
 
Serial _gps(A0, A1); //tx,rx
Serial pc(SERIAL_TX,SERIAL_RX);
DigitalOut myled(LED1);

char nmea[MESS_LEN] = {0x00};
char test[100];
char gp[MAX_STR][STR_LEN]; 


void read_nmea(void);           // read nmea message from gps module
int chop_message(void);         // chop the nmea messeage
void present_gga_array(void);       // send a part of the available info to the laptop
void present_vtg_array(void);       // send a part of the available info to the laptop
void setNmeaMessages( bool ,  bool ,  bool ,  bool ,  bool ,  bool ); 
void setUpdateRate(const uint8_t );
void vtgMessage(bool);


int main() {
     printf("HERE!\n");
     _gps.baud(9600);
     //pc.baud(4800);
    setUpdateRate(1);
    setNmeaMessages(true,false,false,false,false,true);    
    vtgMessage(true);
    //setNavigationMode(0);
    while(1){
        read_nmea();
        
        chop_message();
        present_gga_array();
       // present_vtg_array();
      
       
    }
}

//--------------------read nmea from GPS unit--------------------
void read_nmea(void) {
    _gps.scanf("%s,",nmea);

    pc.printf("Raw message %s \n\r",nmea); // just for testing
}
 
//---------------- chop the nmea message separated by comma's-----------
int chop_message(void) {
    for (int k=0; k<MAX_STR; k++) {          // just to make sure thet the char array is set to 0x00
        for (int l=0; l<STR_LEN; l++) {
            gp[k][l]= 0x00;
        };
    }
    int strcnt=0;                           // string counter
    int strpos=0;                           // position inside the string
    for (int k=0; k < MESS_LEN; k++) {
        if (nmea[k] == '*') {               // detect end of message is found
            gp[strcnt][strpos]= 0x00;       // close the string with 0x00
            return 0;                       // the work is done, end of this function
        }
        if (nmea[k] == 0x2c) {             // detect the comma
            if (strpos == 0) {
                gp[strcnt][0]= 'E';        // comma at position zero, string must be empty
                gp[strcnt][1]= 'm';        // comma at position zero, string must be empty
                gp[strcnt][2]= 'p';        // comma at position zero, string must be empty
                gp[strcnt][3]= 't';        // comma at position zero, string must be empty
                gp[strcnt][4]= 'y';        // comma at position zero, string must be empty
                gp[strcnt][5]= 0x00;       // comma at position zero, string must be empty
            } else {
                gp[strcnt][strpos]= 0x00;   // end the previous string
            }
            strcnt += 1;                    // increment to the next string
            strpos =0;                      // start at position zero
        } else {
            gp[strcnt][strpos]= nmea[k];    // add char to string
            strpos += 1;
        }
    }
    return 0;
}
 
// --------------- Dump only $GPGGA on the screen------------------
void present_gga_array(void) {
    if ((gp[0][2]=='P') and (gp[0][3]=='G') and (gp[0][4]=='G') and (gp[0][5]=='A')) {
        pc.printf("Chop results ");
        for (int k=0; k<MAX_STR; k++) {
            pc.printf("r%d=%s ",k, gp[k]);
        }
        pc.printf("\n\r");
    }
}

// --------------- Dump only $GPVTG on the screen------------------
void present_vtg_array(void) {
    if ( (gp[0][3]=='V') and (gp[0][4]=='T') and (gp[0][5]=='G')) {
        pc.printf("Chop results ");
        for (int k=0; k<MAX_STR; k++) {
            pc.printf("r%d=%s ",k, gp[k]);
        }
        pc.printf("\n\r");
    }
}
//----------------Set Msg Command-----------------------------
void setNmeaMessages( bool gga,  bool gsa,  bool gsv,  bool gll,  bool rmc,  bool vtg) {
   
   //A0, A1, 00, 09 
   //08, 01, 01, 01, 00, 01, 00, 00, 00, 
   //08 0D 0A 
   
    char cmd[15] = {
        0xA0, 0xA1, 0x00, 0x09,
        0x08, 0x01, 0x00, 0x00, 0x00, 0x00, 0x01,0,
        0x00, 0x0D, 0x0A
    };
    
    for(int i = 4; i < 12; i++) cmd[12] ^= cmd[i];
    for(int i = 0; i < 15; i++) _gps.putc(cmd[i]);
}

//----------------Set Update Rate-----------------------------
void setUpdateRate(const uint8_t rate) {
    char cmd[10] = {
        0xA0, 0xA1, 0x00, 0x03,
        0x0E, rate, 0x01,
        0x00, 0x0D, 0x0A
    };
    for(int i = 4; i < 7; i++) cmd[7] ^= cmd[i];
    for(int i = 0; i < 10; i++) _gps.putc(cmd[i]);
}

//----------------Enable VTG---------------------------------
void vtgMessage(bool enable){
     if (enable) {
        _gps.printf("$PSRF103,05,00,01,01*20\r\n");     // Enable VTG 
    } 
    else {
        _gps.printf("$PSRF103,05,00,00,01*21\r\n");     // Disable VTG 
    }
}

//---------------Set Navigation Mode--------------------------
void setNavigationMode(const int mode) {
    char cmd[] = {
       0xA0, 0xA1, 0x00, 0x02,
       0xB5, 0x00,
       0x00, 0x0D, 0x0A 
    };
    for(int i = 4; i < 6; i++) cmd[6] ^= cmd[i];
    for(int i = 0; i < 10; i++) _gps.putc(cmd[i]);
}
 