// ==================================================== Mar 03 2015, kayeks ==
// TextLCD_ST7565SPI.h
// ===========================================================================
// Text console library for ST7565 graphics LCD controller over SPI interface.

#ifndef TEXTLCD_ST7565SPI_H_
#define TEXTLCD_ST7565SPI_H_

#include "mbed.h"

/** Text console library for ST7565 graphics LCD controller over SPI interface. */
class TextLCD_ST7565SPI : public Stream {
public:
    /** Bias select: 1/7 or 1/9. */
    enum Bias {
        Bias1_7    /** 1/7 bias */
        , Bias1_9  /** 1/9 bias */
    };
    
    const static uint8_t V0_INTERNAL_R_0     = 0x20;
    const static uint8_t V0_INTERNAL_R_1     = 0x21;
    const static uint8_t V0_INTERNAL_R_2     = 0x22;
    const static uint8_t V0_INTERNAL_R_3     = 0x23;
    const static uint8_t V0_INTERNAL_R_4     = 0x24;
    const static uint8_t V0_INTERNAL_R_5     = 0x25;
    const static uint8_t V0_INTERNAL_R_6     = 0x26;
    const static uint8_t V0_INTERNAL_R_7     = 0x27;
    const static uint8_t PCTRL_VFOLLOWER_ON  = 0x29;
    const static uint8_t PCTRL_VFOLLOWER_OFF = 0x28;
    const static uint8_t PCTRL_REGULATOR_ON  = 0x2a;
    const static uint8_t PCTRL_REGULATOR_OFF = 0x28;
    const static uint8_t PCTRL_BOOSTER_ON    = 0x2c;
    const static uint8_t PCTRL_BOOSTER_OFF   = 0x28;
    const static uint8_t COMMON_OFFSET       = 0x40;
    const static uint8_t ELECTRONIC_VOL_MODE = 0x81;
    const static uint8_t ELECTRONIC_VOL_1    = 0x01;
    const static uint8_t ELECTRONIC_VOL_2    = 0x02;
    const static uint8_t ELECTRONIC_VOL_3    = 0x03;
    const static uint8_t ELECTRONIC_VOL_4    = 0x04;
    const static uint8_t ELECTRONIC_VOL_5    = 0x05;
    const static uint8_t ELECTRONIC_VOL_6    = 0x06;
    const static uint8_t ELECTRONIC_VOL_7    = 0x07;
    const static uint8_t ELECTRONIC_VOL_8    = 0x08;
    const static uint8_t ELECTRONIC_VOL_9    = 0x09;
    const static uint8_t ELECTRONIC_VOL_10   = 0x0a;
    const static uint8_t ELECTRONIC_VOL_11   = 0x0b;
    const static uint8_t ELECTRONIC_VOL_12   = 0x0c;
    const static uint8_t ELECTRONIC_VOL_13   = 0x0d;
    const static uint8_t ELECTRONIC_VOL_14   = 0x0e;
    const static uint8_t ELECTRONIC_VOL_15   = 0x0f;
    const static uint8_t ELECTRONIC_VOL_16   = 0x10;
    const static uint8_t ELECTRONIC_VOL_17   = 0x11;
    const static uint8_t ELECTRONIC_VOL_18   = 0x12;
    const static uint8_t ELECTRONIC_VOL_19   = 0x13;
    const static uint8_t ELECTRONIC_VOL_20   = 0x14;
    const static uint8_t ELECTRONIC_VOL_21   = 0x15;
    const static uint8_t ELECTRONIC_VOL_22   = 0x16;
    const static uint8_t ELECTRONIC_VOL_23   = 0x17;
    const static uint8_t ELECTRONIC_VOL_24   = 0x18;
    const static uint8_t ELECTRONIC_VOL_25   = 0x19;
    const static uint8_t ELECTRONIC_VOL_26   = 0x1a;
    const static uint8_t ELECTRONIC_VOL_27   = 0x1b;
    const static uint8_t ELECTRONIC_VOL_28   = 0x1c;
    const static uint8_t ELECTRONIC_VOL_29   = 0x1d;
    const static uint8_t ELECTRONIC_VOL_30   = 0x1e;
    const static uint8_t ELECTRONIC_VOL_31   = 0x1f;
    const static uint8_t ELECTRONIC_VOL_32   = 0x20;
    const static uint8_t ELECTRONIC_VOL_33   = 0x21;
    const static uint8_t ELECTRONIC_VOL_34   = 0x22;
    const static uint8_t ELECTRONIC_VOL_35   = 0x23;
    const static uint8_t ELECTRONIC_VOL_36   = 0x24;
    const static uint8_t ELECTRONIC_VOL_37   = 0x25;
    const static uint8_t ELECTRONIC_VOL_38   = 0x26;
    const static uint8_t ELECTRONIC_VOL_39   = 0x27;
    const static uint8_t ELECTRONIC_VOL_40   = 0x28;
    const static uint8_t ELECTRONIC_VOL_41   = 0x29;
    const static uint8_t ELECTRONIC_VOL_42   = 0x2a;
    const static uint8_t ELECTRONIC_VOL_43   = 0x2b;
    const static uint8_t ELECTRONIC_VOL_44   = 0x2c;
    const static uint8_t ELECTRONIC_VOL_45   = 0x2d;
    const static uint8_t ELECTRONIC_VOL_46   = 0x2e;
    const static uint8_t ELECTRONIC_VOL_47   = 0x2f;
    const static uint8_t ELECTRONIC_VOL_48   = 0x30;
    const static uint8_t ELECTRONIC_VOL_49   = 0x31;
    const static uint8_t ELECTRONIC_VOL_50   = 0x32;
    const static uint8_t ELECTRONIC_VOL_51   = 0x33;
    const static uint8_t ELECTRONIC_VOL_52   = 0x34;
    const static uint8_t ELECTRONIC_VOL_53   = 0x35;
    const static uint8_t ELECTRONIC_VOL_54   = 0x36;
    const static uint8_t ELECTRONIC_VOL_55   = 0x37;
    const static uint8_t ELECTRONIC_VOL_56   = 0x38;
    const static uint8_t ELECTRONIC_VOL_57   = 0x39;
    const static uint8_t ELECTRONIC_VOL_58   = 0x3a;
    const static uint8_t ELECTRONIC_VOL_59   = 0x3b;
    const static uint8_t ELECTRONIC_VOL_60   = 0x3c;
    const static uint8_t ELECTRONIC_VOL_61   = 0x3d;
    const static uint8_t ELECTRONIC_VOL_62   = 0x3e;
    const static uint8_t ELECTRONIC_VOL_63   = 0x3f;
    const static uint8_t SEGMENT_ASCENDING   = 0xa0;
    const static uint8_t SEGMENT_DESCENDING  = 0xa1;
    const static uint8_t BIAS_1_9            = 0xa2;
    const static uint8_t BIAS_1_7            = 0xa3;
    const static uint8_t ENTIRE_DISPLAY_OFF  = 0xa4;
    const static uint8_t ENTIRE_DISPLAY_ON   = 0xa5;
    const static uint8_t INVERT_DISPLAY_OFF  = 0xa6;
    const static uint8_t INVERT_DISPLAY_ON   = 0xa7;
    const static uint8_t DISPLAY_OFF         = 0xae;
    const static uint8_t DISPLAY_ON          = 0xaf;
    const static uint8_t COMMON_ASCENDING    = 0xc0;
    const static uint8_t COMMON_DESCENDING   = 0xc8;
    const static uint8_t MODIFY_WRITE_ON     = 0xe0;
    const static uint8_t INTERNAL_RESET      = 0xe2;
    const static uint8_t MODIFY_WRITE_OFF    = 0xee;
    
    const static uint8_t FONT_5X7[128][5];
    
private:
    uint8_t**  _lineBuffer;
    uint8_t    _column, _row;
    uint8_t    _columns, _rows;
    DigitalOut _rs;
    DigitalOut _rst;
    SPI        _spi;
    DigitalOut _cs;

public:
    /** Constructor of class TextLCD_ST7565SPI.
     * @param mosi     SPI data output (MOSI) pin.
     * @param sck      SPI clock output (SCK) pin.
     * @param cs       SPI Chip select (CS) pin.
     * @param rs       Register select (RS or A0) pin.
     * @param rst      Hardware reset (RST) pin.
     * @param columns  Number of characters in a row.
     * @param rows     Number of rows. 
     */
    TextLCD_ST7565SPI(PinName mosi, PinName sck, PinName cs,
                      PinName rs, PinName rst,
                      uint8_t columns, uint8_t rows);
    
    /** Destructor of class TextLCD_ST7565SPI. */
    virtual ~TextLCD_ST7565SPI();
    
    /** Hit hardware reset pin. */
    void reset();
    
    /** Initialize controller.
     * @param v0        Internal V0 setting (0..7).
     * @param contrast  Contrast setting (0..63).
     * @param bias      Bias configuration for your LCD.
     */
    void init(uint8_t v0, uint8_t contrast, Bias bias);

    /** Clear display and set cursor to home. */    
    void cls();
    
    /** Set cursor position for next character.
     * @param column  Column position indexed from 0.
     * @param row     Row position indexed from 0.
     */
    void locate(uint8_t column, uint8_t row);
    
private:
    /** Implementation of putc from Stream class. */
    virtual int _putc(int c);
    
    /** Implementation of getc from Stream class. */
    virtual int _getc();

    /** Shift up the lower line for scrolling. */
    void shiftUp();

    /** Clear entire display. */
    void clear();

    /** Set page position for next data.
     * @param page  Page position indexed from 0 to 7.
     */ 
    void setPage(uint8_t page);
    
    /** Set column position for next data.
     * @param column  Column position indexed from 0.
     */
    void setColumn(uint8_t column);
    
    /** Write a command byte for LCD controller.
     * @param c  The command byte.
     */
    void command(uint8_t c);

    /** Write a data byte for LCD controller.
     * @param d  The data byte.
     */
    void data(uint8_t d);
};

#endif
