#include "mbed.h"
#include "ST7565SPI.h"

ST7565SPI lcd(/*MOSI*/ p5, /*SCK*/ p7, /*CS*/ p8,
              /*RS*/ p11, /*RST*/ p12, /*Frequency*/ 1000000);

// Dithered gray patterns
uint8_t const pattern[8][4] = {
    { 0xff, 0xff, 0xff, 0xff },  // 100%
    { 0x77, 0xff, 0xdd, 0xff },  // 87.5%
    { 0x55, 0xff, 0x55, 0xff },  // 75%
    { 0x55, 0xbb, 0x55, 0xee },  // 62.5%
    { 0x55, 0xaa, 0x55, 0xaa },  // 50%
    { 0x55, 0x22, 0x55, 0x88 },  // 37.5%
    { 0x55, 0x00, 0x55, 0x00 },  // 25%
    { 0x11, 0x00, 0x44, 0x00 }   // 12.5% 
};

int main(void) {
    // Initialize LCD
    lcd.init(/*V0*/ 3, /*Contrast*/ 48, /*Bias*/ ST7565SPI::Bias1_9);
    
    // Draw horizontal stripes
    for (uint8_t j = 0; j < 8; j++) {
        lcd.setPage(j);
        lcd.setColumn(0);
        for (uint8_t i = 0; i < 128 / 4; i++) {
            lcd.data(pattern[j][0]);
            lcd.data(pattern[j][1]);
            lcd.data(pattern[j][2]);
            lcd.data(pattern[j][3]);
        }
    }
    
    // Scroll entire display by changing line offset values
    uint8_t c = 0;
    while (1) {
        lcd.command(ST7565SPI::COMMON_OFFSET + c);
        if (c == 0) {
            c = 63;
        } else {
            c--;
        }
        wait(.25);
    }
}
