// ==================================================== Mar 02 2015, kayeks ==
// ST7565SPI.cpp
// ===========================================================================
// Driver library for ST7565 graphics LCD controller over SPI interface.

#include "ST7565SPI.h"

ST7565SPI::ST7565SPI(PinName mosi, PinName sck, PinName cs,
                     PinName rs, PinName rst, int frequency)
:
    _rs(rs),
    _rst(rst),
    _spi(mosi, NC, sck),
    _cs(cs)
{
    // Initialize SPI
    _spi.format(8, 0);
    _spi.frequency(frequency);
    
    // Initialize pins
    _rs = 0;
    _rst = 1;
    _cs = 1;
    
    reset();
}

ST7565SPI::~ST7565SPI() {
}

void ST7565SPI::reset() {
    wait_ms(10);
    _rst = 0;
    wait_ms(10);
    _rst = 1;
}

void ST7565SPI::clear() {
    for (uint8_t j = 7; j <= 7; j--) {
        setPage(j);
        setColumn(0);
        for (uint8_t i = 0; i < 132; i++) {
            data(0x00);
        }
    }
}

void ST7565SPI::init(uint8_t v0, uint8_t contrast, Bias bias) {
    command(INTERNAL_RESET);
    wait_ms(5);
    
    command(DISPLAY_ON);
    command(PCTRL_BOOSTER_ON | PCTRL_REGULATOR_ON | PCTRL_VFOLLOWER_ON);
    command(V0_INTERNAL_R_0 + (v0 & 0x07));
    command(ELECTRONIC_VOL_MODE);
    if (contrast == 0) {
        contrast = 1;
    }
    command(ELECTRONIC_VOL_1 - 1 + (contrast & 0x3f));
    switch (bias) {
    case Bias1_7:
        command(BIAS_1_7);
        break;
    case Bias1_9:
        command(BIAS_1_9);
    }
    command(COMMON_ASCENDING);
    command(SEGMENT_ASCENDING);
    command(ENTIRE_DISPLAY_OFF);
    command(INVERT_DISPLAY_OFF);
    command(COMMON_OFFSET);
    clear();
}

void ST7565SPI::setPage(uint8_t page) {
    if (page < 16) {
        command(0xb0 | page);
    }
}

void ST7565SPI::setColumn(uint8_t column) {
    command(0x10 | (column >> 4));
    command(column & 0x0f);
}

void ST7565SPI::command(uint8_t c) {
    _rs = 0;
    _cs = 0;
    _spi.write(c);
    _cs = 1;
}

void ST7565SPI::data(uint8_t d) {
    _rs = 1;
    _cs = 0;
    _spi.write(d);
    _cs = 1;
}
