#include "mbed.h"
#include "TextLCD.h"

#include "define.h"
#include "MIDIChannel.h"
#include "Instrument.h"
#include "RingBuffer.h"
#include "events.h"
#include "parser.h"

Serial midiIn(/*Tx*/ NC, /*Rx*/ p10);
TextLCD lcd(/*RS*/ p26, /*E*/ p25, /*D4 through D7*/ p24, p23, p22, p21, TextLCD::LCD16x2);
BusOut obLeds(LED1, LED2, LED3, LED4);
I2C i2c(/*SDA*/ p28, /*SCL*/ p27);
Timer t;
#ifdef USE_PC_SERIAL
Serial pc(/*Tx*/ USBTX, /*Rx*/ USBRX);
#endif

uint8_t const performerAddress[NUM_PERFORMER] = { 0x34 };

Instrument inst[NUM_INSTRUMENT];
uint32_t receivedBytes;
RingBuffer<char> buffer(BUFFER_LENGTH);

extern "C"
void HardFault_Handler() {
    volatile uint32_t i;
    
    while (1) {
        i = 0;
        obLeds = obLeds ^ 0x8;
        while (i < 1000000) i++;
    }
}

void readMidiIn() {
    char c;
    
    // Put a MIDI input byte into buffer if available
    if (midiIn.readable()) {
        c = midiIn.getc();
        receivedBytes++;

        // Discard if input byte is an active sensing message
        if (c != 0xfe) {
            buffer.write(c);
            /*
            #ifdef USE_PC_SERIAL
            pc.printf("%02X\r\n", c);
            #endif
            */
        }
    }
}

void setup() {
    // Setup MIDI port
    midiIn.baud(31250);
    midiIn.format(8, Serial::None, 1);
    midiIn.attach(readMidiIn, Serial::RxIrq);
    receivedBytes = 0;
    
    #ifdef USE_PC_SERIAL
    // Setup PC Serial port
    pc.baud(115200);
    pc.format(8, Serial::None, 1);
    #endif

    // Initialize Text LCD
    lcd.cls();
    wait_ms(10);
    
    // Initialize onboard LEDs
    obLeds = 0x0;

    // Start Timer
    t.start();
}

void loop() {
    /*
    lcd.locate(0, 0);
    lcd.printf("Recv'd: %8u", receivedBytes);
    lcd.locate(0, 1);
    lcd.printf("Buffer: %8u", buffer.items());
    */
    
    // Parse message buffer
    parseMessage(buffer);
}

int main() {
    setup();
    
    while (1) {
        loop();
    }
}
