#include <climits>
#include "mbed.h"

#include "define.h"
#include "Instrument.h"
#include "RingBuffer.h"

extern Timer t;

extern Instrument inst[NUM_INSTRUMENT];
extern uint8_t const performerAddress[NUM_PERFORMER];


void dispatchNoteOff(uint8_t statusByte, uint8_t noteNumber) {
    uint16_t targetPerformer;
    char message[2];

    // Find an Instrument sounding the specified note
    for (uint16_t i = 0; i < NUM_INSTRUMENT; i++) {
        if (inst[i].channel == (statusByte & 0x0f) + 1
            && inst[i].noteNumber == noteNumber) {
            inst[i].noteOnMs = 0;
            inst[i].channel = 0;
            inst[i].noteNumber = 0;
            inst[i].velocity = 0;
            
            // Send note off message to Performer
            targetPerformer = i / NUM_INSTRUMENT_IN_PERFORMER;
            message[0] = 0x80;
            message[1] = i % NUM_INSTRUMENT_IN_PERFORMER;
            // i2c.write(performerAddress[targetPerformer] << 1, message, 2);
            return;
        }
    }
}

void dispatchNoteOn(uint8_t statusByte, uint8_t noteNumber, uint8_t velocity) {
    uint32_t currentMs = t.read_ms();
    uint32_t oldestMs = UINT_MAX;
    uint16_t oldest = 0;
    uint16_t targetPerformer;
    char message[4];
    
    // Find a free Instrument or the one with the oldest note
    for (uint16_t i = 0; i < NUM_INSTRUMENT; i++) {
        if (inst[i].noteOnMs < oldestMs) {
            oldest = i;
            oldestMs = inst[i].noteOnMs;
        }
    }
    
    inst[oldest].noteOnMs = currentMs;
    inst[oldest].channel = (statusByte & 0x0f) + 1;
    inst[oldest].noteNumber = noteNumber;
    inst[oldest].velocity = velocity;
        
    // Send note on message to Performer
    targetPerformer = oldest / NUM_INSTRUMENT_IN_PERFORMER;
    message[0] = statusByte;
    message[1] = oldest % NUM_INSTRUMENT_IN_PERFORMER;
    message[2] = noteNumber;
    message[3] = velocity;
    // i2c.write(performerAddress[targetPerformer] << 1, message, 4);
}

void setControlChange(uint8_t statusByte, uint8_t controlNumber, uint8_t value) {
    char message[3];
    
    message[0] = statusByte;
    message[1] = controlNumber;
    message[2] = value;
    /*
    for (uint8_t i = 0; i < NUM_PERFORMER; i++) {
        i2c.write(performerAddress[i] << 1, message, 3);
    }
    */
}

void setProgramChange(uint8_t statusByte, uint8_t programNumber) {
    char message[2];
    
    message[0] = statusByte;
    message[1] = programNumber;
    /*
    for (uint8_t i = 0; i < NUM_PERFORMER; i++) {
        i2c.write(performerAddress[i] << 1, message, 2);
    }
    */
}

void setPitchBend(uint8_t statusByte, uint16_t bend) {
    char message[3];
    
    message[0] = statusByte;
    message[1] = bend >> 8;
    message[2] = bend & 0x00ff;
    /*
    for (uint8_t i = 0; i < NUM_PERFORMER; i++) {
        i2c.write(performerAddress[i] << 1, message, 3);
    }
    */
}
