#ifndef ISU_PROJECT_DEFS_H_
#define ISU_PROJECT_DEFS_H_

// Input thresholds
#define H_TO_L_THRES       0.25
#define L_TO_H_THRES       0.75

// Delay count until settling
#define SETTLING_COUNT        5

// Polling interval (second)
#define POLL_INTERVAL_SEC  0.25

// Block size of read/write (byte)
#define BLOCK_SIZE           64

typedef enum {
    CANCELING = -1,
    STOPPING  = -2,
    READY     =  0,
    PLAYING1  =  1,
    PLAYING2  =  2,
    PLAYING3  =  3,
    PLAYING4  =  4
} State;

typedef enum {
    STOP_REQUEST  = -1,
    NONE          =  0,
    PLAY1_REQUEST =  1,
    PLAY2_REQUEST =  2,
    PLAY3_REQUEST =  3,
    PLAY4_REQUEST =  4
} Request;

PinName const xp5  = P0_9;   // (p5)   SPI1 + MOSI
PinName const xp6  = P0_8;   // (p6)        | MISO
PinName const xp7  = P0_7;   // (p7)        | SCK
PinName const xp8  = P0_6;   // (p8)        | SSEL#
PinName const xp9  = P0_0;   // (p9)   UART3+ Tx     I2C1 + SDA
PinName const xp10 = P0_1;   // (p10)       | Rx          | SCL
PinName const xp11 = P0_18;  // (p11)                SPI0 + MOSI
PinName const xp12 = P0_17;  // (p12)                     | MISO
PinName const xp13 = P0_15;  // (p13)  UART1+ Tx          | SCK
PinName const xp14 = P0_16;  // (p14)       | Rx          | SSEL#
PinName const xp15 = P0_23;  // (p15)  AnalogIn
PinName const xp16 = P0_24;  // (p16)  AnalogIn
PinName const xp17 = P0_25;  // (p17)  AnalogIn
PinName const xp18 = P0_26;  // (p18)  AnalogIn  AnalogOut
PinName const xp19 = P1_30;  // (p19)  AnalogIn
PinName const xp20 = P1_31;  // (p20)  AnalogIn
PinName const xp21 = P0_2;
PinName const xp22 = P0_3;
PinName const xp23 = P0_21;
PinName const xp24 = P0_22;  // **Onboard LED
PinName const xp25 = P0_27;  // **Open drain
PinName const xp26 = P0_28;  // **Open drain
PinName const xp27 = P2_13;
PinName const xp53 = P2_12;
PinName const xp52 = P2_11;
PinName const xp51 = P2_10;
PinName const xp50 = P2_8;
PinName const xp49 = P2_7;
PinName const xp48 = P2_6;
PinName const xp47 = P2_5;   // (p21)  PwmOut
PinName const xp46 = P2_4;   // (p22)  PwmOut
PinName const xp45 = P2_3;   // (p23)  PwmOut
PinName const xp44 = P2_2;   // (p24)  PwmOut
PinName const xp43 = P2_1;   // (p25)  PwmOut
PinName const xp42 = P2_0;   // (p26)  PwmOut
PinName const xp41 = P0_11;  // (p27)  UART2+ Rx     I2C2 + SCL
PinName const xp40 = P0_10;  // (p28)       | Tx          | SDA
PinName const xp39 = P0_5;   // (p29)  CAN  + TD
PinName const xp38 = P0_4;   // (p30)       | RD
PinName const LED0 = P0_22;

#endif
