// ==================================================== Dec 21 2013, kayeks ==
// HysteresisIn.h
// ===========================================================================
// Analog to binary input class with hysteresis
//   - For a simple Schmitt-Trigger substitute

#ifndef HYSTERESIS_IN_H_
#define HYSTERESIS_IN_H_

#include "mbed.h"

class HysteresisIn {
private:
    AnalogIn in; 
    float thresholdHighToLow;
    float thresholdLowToHigh;
    bool state;
    
public:
    HysteresisIn(PinName inputPin, float htl, float lth, bool initialState=0);
    ~HysteresisIn();
    bool read();
    void write(bool newState);
};

#endif
