// ==================================================== Dec 21 2013, kayeks ==
// HysteresisIn.cpp
// ===========================================================================
// Analog to binary input class with hysteresis
//   - For a simple Schmitt-Trigger substitute

#include "HysteresisIn.h"

/** Constructor of class HysteresisIn */
HysteresisIn::HysteresisIn(PinName inputPin, float htl, float lth,
                           bool initialState)
:
    in(inputPin)
{
    this->state = initialState;
    this->thresholdHighToLow = htl;
    this->thresholdLowToHigh = lth;
}

/** Destructor of class HysteresisIn */
HysteresisIn::~HysteresisIn() {
}

/* Read once and decide an output */
bool HysteresisIn::read() {
    float val = in;
    if (this->state && val < this->thresholdHighToLow) {
        this->state = 0;
    } else if (!this->state && val > this->thresholdLowToHigh) {
        this->state = 1;
    }
    return this->state;
}

/* Forcibly set current state */
void HysteresisIn::write(bool newState) {
    this->state = newState;
}
