#ifndef HT1621_H_
#define HT1621_H_

class HT1621 {
private:
    DigitalOut wr;
    DigitalOut data;
    DigitalOut cs;
    
public:
    // Commands
    const static uint8_t SYS_DIS     = 0x00;
    const static uint8_t SYS_EN      = 0x01;
    const static uint8_t LCD_OFF     = 0x02;
    const static uint8_t LCD_ON      = 0x03;
    const static uint8_t TIMER_DIS   = 0x04;
    const static uint8_t WDT_DIS     = 0x05;
    const static uint8_t TIMER_EN    = 0x06;
    const static uint8_t WDT_EN      = 0x07;
    const static uint8_t TONE_OFF    = 0x08;
    const static uint8_t TONE_ON     = 0x09;
    const static uint8_t CLR_TIMER   = 0xc0;
    const static uint8_t CLR_WDT     = 0xe0;
    const static uint8_t XTAL_32K    = 0x14;
    const static uint8_t RC_256K     = 0x18;
    const static uint8_t EXT_256K    = 0x1c;
    const static uint8_t BIAS2_COM2  = 0x20;
    const static uint8_t BIAS3_COM2  = 0x21;
    const static uint8_t BIAS2_COM3  = 0x24;
    const static uint8_t BIAS3_COM3  = 0x25;
    const static uint8_t BIAS2_COM4  = 0x28;
    const static uint8_t BIAS3_COM4  = 0x29;
    const static uint8_t TONE_4K     = 0x40;
    const static uint8_t TONE_2K     = 0x60;
    const static uint8_t IRQ_DIS     = 0x80;
    const static uint8_t IRQ_EN      = 0x88;
    const static uint8_t F1          = 0xa0;
    const static uint8_t F2          = 0xa1;
    const static uint8_t F4          = 0xa2;
    const static uint8_t F8          = 0xa3;
    const static uint8_t F16         = 0xa4;
    const static uint8_t F32         = 0xa5;
    const static uint8_t F64         = 0xa6;
    const static uint8_t F128        = 0xa7;
    const static uint8_t TEST        = 0xe0;
    const static uint8_t NORMAL      = 0xe3;
    
    HT1621(PinName wrPin, PinName dataPin, PinName csPin);
    ~HT1621();
    
    void write(uint8_t addr, uint8_t b);
    void command(uint8_t b);
};

#endif
