#include "mbed.h"
#include "HT1621.h"

HT1621::HT1621(PinName wrPin, PinName dataPin, PinName csPin)
:
    wr(wrPin),
    data(dataPin),
    cs(csPin)
{
    wr = 1;
    cs = 1;
    
    command(SYS_DIS);
    wait(0.2);
    command(SYS_EN);
    command(RC_256K);
    command(LCD_OFF);
    
    // Clear all segments
    for (uint8_t i = 0; i < 64; i++) {
        write(i, 0x00);
    }
    command(LCD_ON);
}

HT1621::~HT1621() {
}

void HT1621::command(uint8_t b) {
    // 11 10  9  8| 7  6  5  4| 3  2  1  0
    // --------+--+-----------+-----------
    //  1  0  0|              command<8:0>
    uint16_t word = 0x0800 | (b << 1);
    
    cs = 0;
    for (uint8_t i = 11; i <= 11; i--) {
        wr = 0;
        data = word & (0x0001 << i) ? 1 : 0;
        wr = 1;
    }
    cs = 1;
}

void HT1621::write(uint8_t addr, uint8_t b) {
    // 12|11 10  9  8| 7  6  5  4| 3  2  1  0
    // --+-----+-----+-----------+-----------
    //  1  0  1|     address<5:0>|   seg<3:0>
    uint16_t word = 0x1400 | ((addr & 0x3f) << 4) | (b & 0x0f);
    
    cs = 0;
    for (uint8_t i = 12; i <= 12; i--) {
        wr = 0;
        data = word & (0x0001 << i) ? 1 : 0;
        wr = 1;
    }
    cs = 1;
}
