#include <stdarg.h>
#include "mbed.h"
#include "defs.h"
#include "RingBuffer.h"
#include "debug.h"
#include "note.h"

extern Serial           console;
extern note_t           noteSent[NUM_INSTRUMENT];
extern RingBuffer<char> buffer;
extern dumpmode_t       dumpMode;

void checkBuffer() {
    size_t bufferCount = buffer.getItemCount();
    size_t bufferCountToDisplay;
    char*  bufferPtr = NULL;

    if (bufferCount) {
        bufferPtr = buffer.peek();
        bufferCountToDisplay = bufferCount > 16 ? 16 : bufferCount;
        
        console.printf("* %u byte%c in buffer", bufferCount,
                       bufferCount == 1 ? '\0' : 's');
        if (bufferCount > 16) {
            console.printf(". The first 16 bytes:\r\n ");
        } else {
            console.printf(":\r\n ");
        }
        for (uint8_t i = 0; i < bufferCountToDisplay; i++) {
            console.printf(" %02X", *bufferPtr++);
        }
        console.printf("h\r\n");
    } else {
        console.printf("* Buffer is empty.\r\n");
    }
}

void dumpInstrumentList() {
    char const channelLetter[] = {
        '-', '1', '2', '3', '4', '5', '6', '7', '8',
        '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G'
    };
    
    if (dumpMode == DUMP_INST_DETAIL) {
        console.printf("\r\n");
        for (uint16_t i = 0; i < NUM_INSTRUMENT; i++) {
            if (noteSent[i].channel) {
                console.printf("#%2d  ch=%2d n=%02Xh v=%02Xh ms=%lu\r\n",
                               i, noteSent[i].channel, noteSent[i].noteNumber,
                               noteSent[i].velocity, noteSent[i].noteOnMs);
            } else {
                console.printf("#%2d         not in use\r\n", i);
            }
        }
    } else if (dumpMode == DUMP_INST) {
        for (uint16_t i = 0; i < NUM_INSTRUMENT; i++) {
            console.printf(" %c", channelLetter[noteSent[i].channel]);
        }
        console.printf("\r\n");
    }
}
