#ifndef WAVETABLE_H_
#define WAVETABLE_H_

#define WAVETABLE_LENGTH  256

class Wavetable {
public:
    typedef enum {
        Sine           = 0,
        Square         = 1,
        Pulse1_3       = 2,
        Pulse1_7       = 3,
        Sawtooth       = 4,
        Triangle       = 5,
        CoarseTriangle = 6,
        SpikedSine     = 7,
        Noise          = 8,
        LowPeriodNoise = 9
    } wavetype_t;
    typedef struct {
        wavetype_t wavetype;
        uint8_t    decaySpeed;
        uint8_t    sustainLevel;
    } wave_t;
    
    static const uint8_t* const waveTableList[];
    static wave_t const waveDefList[128];
    static uint8_t const sineTable[WAVETABLE_LENGTH];
    static uint8_t const squareTable[WAVETABLE_LENGTH];
    static uint8_t const pulse1_3Table[WAVETABLE_LENGTH];
    static uint8_t const pulse1_7Table[WAVETABLE_LENGTH];
    static uint8_t const sawtoothTable[WAVETABLE_LENGTH];
    static uint8_t const triangleTable[WAVETABLE_LENGTH];
    static uint8_t const coarseTriangleTable[WAVETABLE_LENGTH];
    static uint8_t const spikedSineTable[WAVETABLE_LENGTH];
};

#endif
