#ifndef GEMINICORE_H_
#define GEMINICORE_H_

#include <stdint.h>
#include "note.h"
#include "Instrument.h"

class GeminiCore {
private:
    Instrument* instrumentList;
    uint8_t     numInstruments;
    uint8_t*    prevSample;      // previous sample value (used for noise samples)
    uint8_t     x8;              // 8-bit random seed
    uint16_t    x16;             // 16-bit random seed
    uint16_t    samplingRate;
       
public:
    GeminiCore(uint8_t, uint16_t);
    ~GeminiCore();
    uint16_t makeSample(note_t*);
    bool enable(uint8_t);
    bool disable(uint8_t);
    bool noteOn(uint8_t, uint16_t, uint8_t);
    bool noteOff(uint8_t);
    bool volume(uint8_t, uint8_t);
    bool expression(uint8_t, uint8_t);
    bool pitchBend(uint8_t, int16_t);
    bool setWave(uint8_t, Wavetable::wave_t);
    
    Instrument* getInstrumentList();
    uint32_t getPlaybackStartTime();

private:
    uint8_t rand8();
    uint16_t rand16();
};

#endif
