#include "mbed.h"
#include "Wavetable.h"

const uint8_t* const Wavetable::waveTableList[] = {
    Wavetable::sineTable,
    Wavetable::squareTable,
    Wavetable::pulse1_3Table,
    Wavetable::pulse1_7Table,
    Wavetable::sawtoothTable,
    Wavetable::triangleTable,
    Wavetable::coarseTriangleTable,
    Wavetable::spikedSineTable,
    NULL,
    NULL
};

Wavetable::wave_t const Wavetable::waveDefList[128] = {
    // 00h..07h  Piano
    { Wavetable::Sine, 8, 255 },
    { Wavetable::Sine, 8, 128 },
    { Wavetable::Sine, 8,  32 },
    { Wavetable::Sine, 8,   8 },
    { Wavetable::Sine, 7,   8 },
    { Wavetable::Sine, 6,   8 },
    { Wavetable::Sine, 5,   8 },
    { Wavetable::Sine, 5,   0 },
    // 08h..0Fh  Chromatic Percussion
    { Wavetable::Square, 8, 255 },
    { Wavetable::Square, 8, 128 },
    { Wavetable::Square, 8,  32 },
    { Wavetable::Square, 8,   8 },
    { Wavetable::Square, 7,   8 },
    { Wavetable::Square, 6,   8 },
    { Wavetable::Square, 5,   8 },
    { Wavetable::Square, 5,   0 },
    // 10h..17h  Organ
    { Wavetable::Pulse1_3, 8, 255 },
    { Wavetable::Pulse1_3, 8, 128 },
    { Wavetable::Pulse1_3, 8,  32 },
    { Wavetable::Pulse1_3, 8,   8 },
    { Wavetable::Pulse1_3, 7,   8 },
    { Wavetable::Pulse1_3, 6,   8 },
    { Wavetable::Pulse1_3, 5,   8 },
    { Wavetable::Pulse1_3, 5,   0 },
    // 18h..1Fh  Guitar
    { Wavetable::Pulse1_7, 8, 255 },
    { Wavetable::Pulse1_7, 8, 128 },
    { Wavetable::Pulse1_7, 8,  32 },
    { Wavetable::Pulse1_7, 8,   8 },
    { Wavetable::Pulse1_7, 7,   8 },
    { Wavetable::Pulse1_7, 6,   8 },
    { Wavetable::Pulse1_7, 5,   8 },
    { Wavetable::Pulse1_7, 5,   0 },
    // 20h..27h  Bass
    { Wavetable::Sawtooth, 8, 255 },
    { Wavetable::Sawtooth, 8, 128 },
    { Wavetable::Sawtooth, 8,  32 },
    { Wavetable::Sawtooth, 8,   8 },
    { Wavetable::Sawtooth, 7,   8 },
    { Wavetable::Sawtooth, 6,   8 },
    { Wavetable::Sawtooth, 5,   8 },
    { Wavetable::Sawtooth, 5,   0 },
    // 28h..2Fh  Strings
    { Wavetable::Triangle, 8, 255 },
    { Wavetable::Triangle, 8, 128 },
    { Wavetable::Triangle, 8,  32 },
    { Wavetable::Triangle, 8,   8 },
    { Wavetable::Triangle, 7,   8 },
    { Wavetable::Triangle, 6,   8 },
    { Wavetable::Triangle, 5,   8 },
    { Wavetable::Triangle, 5,   0 },
    // 30h..37h  Emsemble
    { Wavetable::CoarseTriangle, 8, 255 },
    { Wavetable::CoarseTriangle, 8, 128 },
    { Wavetable::CoarseTriangle, 8,  32 },
    { Wavetable::CoarseTriangle, 8,   8 },
    { Wavetable::CoarseTriangle, 7,   8 },
    { Wavetable::CoarseTriangle, 6,   8 },
    { Wavetable::CoarseTriangle, 5,   8 },
    { Wavetable::CoarseTriangle, 5,   0 },
    // 38h..3Fh  Brass
    { Wavetable::SpikedSine, 8, 255 },
    { Wavetable::SpikedSine, 8, 128 },
    { Wavetable::SpikedSine, 8,  32 },
    { Wavetable::SpikedSine, 8,   8 },
    { Wavetable::SpikedSine, 7,   8 },
    { Wavetable::SpikedSine, 6,   8 },
    { Wavetable::SpikedSine, 5,   8 },
    { Wavetable::SpikedSine, 5,   0 },
    // 40h..47h  Reed
    { Wavetable::Noise, 8, 255 },
    { Wavetable::Noise, 8, 128 },
    { Wavetable::Noise, 8,  32 },
    { Wavetable::Noise, 8,   8 },
    { Wavetable::Noise, 7,   8 },
    { Wavetable::Noise, 6,   8 },
    { Wavetable::Noise, 5,   8 },
    { Wavetable::Noise, 5,   0 },
    // 48h..4Fh  Pipe
    { Wavetable::LowPeriodNoise, 8, 255 },
    { Wavetable::LowPeriodNoise, 8, 128 },
    { Wavetable::LowPeriodNoise, 8,  32 },
    { Wavetable::LowPeriodNoise, 8,   8 },
    { Wavetable::LowPeriodNoise, 7,   8 },
    { Wavetable::LowPeriodNoise, 6,   8 },
    { Wavetable::LowPeriodNoise, 5,   8 },
    { Wavetable::LowPeriodNoise, 5,   0 },
    // 50h..57h  Synth Lead
    { Wavetable::Sine, 8, 255 },
    { Wavetable::Sine, 8, 128 },
    { Wavetable::Sine, 8,  32 },
    { Wavetable::Sine, 8,   8 },
    { Wavetable::Sine, 7,   8 },
    { Wavetable::Sine, 6,   8 },
    { Wavetable::Sine, 5,   8 },
    { Wavetable::Sine, 5,   0 },
    // 58h..5Fh  Synth Pad
    { Wavetable::Sine, 8, 255 },
    { Wavetable::Sine, 8, 128 },
    { Wavetable::Sine, 8,  32 },
    { Wavetable::Sine, 8,   8 },
    { Wavetable::Sine, 7,   8 },
    { Wavetable::Sine, 6,   8 },
    { Wavetable::Sine, 5,   8 },
    { Wavetable::Sine, 5,   0 },
    // 60h..67h  Synth Effects
    { Wavetable::Sine, 8, 255 },
    { Wavetable::Sine, 8, 128 },
    { Wavetable::Sine, 8,  32 },
    { Wavetable::Sine, 8,   8 },
    { Wavetable::Sine, 7,   8 },
    { Wavetable::Sine, 6,   8 },
    { Wavetable::Sine, 5,   8 },
    { Wavetable::Sine, 5,   0 },
    // 68h..6Fh  Ethnic
    { Wavetable::Sine, 8, 255 },
    { Wavetable::Sine, 8, 128 },
    { Wavetable::Sine, 8,  32 },
    { Wavetable::Sine, 8,   8 },
    { Wavetable::Sine, 7,   8 },
    { Wavetable::Sine, 6,   8 },
    { Wavetable::Sine, 5,   8 },
    { Wavetable::Sine, 5,   0 },
    // 70h..77h  Percussive
    { Wavetable::Sine, 8, 255 },
    { Wavetable::Sine, 8, 128 },
    { Wavetable::Sine, 8,  32 },
    { Wavetable::Sine, 8,   8 },
    { Wavetable::Sine, 7,   8 },
    { Wavetable::Sine, 6,   8 },
    { Wavetable::Sine, 5,   8 },
    { Wavetable::Sine, 5,   0 },
    // 78h..7Fh  Sound Effects
    { Wavetable::Sine, 8, 255 },
    { Wavetable::Sine, 8, 128 },
    { Wavetable::Sine, 8,  32 },
    { Wavetable::Sine, 8,   8 },
    { Wavetable::Sine, 7,   8 },
    { Wavetable::Sine, 6,   8 },
    { Wavetable::Sine, 5,   8 },
    { Wavetable::Sine, 5,   0 },
};

uint8_t const Wavetable::sineTable[WAVETABLE_LENGTH] = {
    0x80, 0x83, 0x86, 0x89, 0x8c, 0x8f, 0x92, 0x95,
    0x98, 0x9b, 0x9e, 0xa1, 0xa4, 0xa7, 0xaa, 0xad,
    0xb0, 0xb3, 0xb6, 0xb9, 0xbb, 0xbe, 0xc1, 0xc3,
    0xc6, 0xc9, 0xcb, 0xce, 0xd0, 0xd2, 0xd5, 0xd7,
    0xd9, 0xdb, 0xde, 0xe0, 0xe2, 0xe4, 0xe6, 0xe7,
    0xe9, 0xeb, 0xec, 0xee, 0xf0, 0xf1, 0xf2, 0xf4,
    0xf5, 0xf6, 0xf7, 0xf8, 0xf9, 0xfa, 0xfb, 0xfb,
    0xfc, 0xfd, 0xfd, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe,
    
    0xff, 0xfe, 0xfe, 0xfe, 0xfe, 0xfe, 0xfd, 0xfd,
    0xfc, 0xfb, 0xfb, 0xfa, 0xf9, 0xf8, 0xf7, 0xf6,
    0xf5, 0xf4, 0xf2, 0xf1, 0xf0, 0xee, 0xec, 0xeb,
    0xe9, 0xe7, 0xe6, 0xe4, 0xe2, 0xe0, 0xde, 0xdb,
    0xd9, 0xd7, 0xd5, 0xd2, 0xd0, 0xce, 0xcb, 0xc9,
    0xc6, 0xc3, 0xc1, 0xbe, 0xbb, 0xb9, 0xb6, 0xb3,
    0xb0, 0xad, 0xaa, 0xa7, 0xa4, 0xa1, 0x9e, 0x9b,
    0x98, 0x95, 0x92, 0x8f, 0x8c, 0x89, 0x86, 0x83,
    
    0x7f, 0x7c, 0x79, 0x76, 0x73, 0x70, 0x6d, 0x6a,
    0x67, 0x64, 0x61, 0x5e, 0x5b, 0x58, 0x55, 0x52,
    0x4f, 0x4c, 0x49, 0x46, 0x44, 0x41, 0x3e, 0x3c,
    0x39, 0x36, 0x34, 0x31, 0x2f, 0x2d, 0x2a, 0x28,
    0x26, 0x24, 0x21, 0x1f, 0x1d, 0x1b, 0x19, 0x18,
    0x16, 0x14, 0x13, 0x11, 0x0f, 0x0e, 0x0d, 0x0b,
    0x0a, 0x09, 0x08, 0x07, 0x06, 0x05, 0x04, 0x04,
    0x03, 0x02, 0x02, 0x01, 0x01, 0x01, 0x01, 0x01,
    
    0x01, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02,
    0x03, 0x04, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09,
    0x0a, 0x0b, 0x0d, 0x0e, 0x0f, 0x11, 0x13, 0x14,
    0x16, 0x18, 0x19, 0x1b, 0x1d, 0x1f, 0x21, 0x24,
    0x26, 0x28, 0x2a, 0x2d, 0x2f, 0x31, 0x34, 0x36,
    0x39, 0x3c, 0x3e, 0x41, 0x44, 0x46, 0x49, 0x4c,
    0x4f, 0x52, 0x55, 0x58, 0x5b, 0x5e, 0x61, 0x64,
    0x67, 0x6a, 0x6d, 0x70, 0x73, 0x76, 0x79, 0x7c
};

uint8_t const Wavetable::squareTable[WAVETABLE_LENGTH] = {
    0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
    0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
    0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
    0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
    0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
    0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
    0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
    0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,

    0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
    0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
    0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
    0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
    0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
    0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
    0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
    0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,

    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,

    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40
};

uint8_t const Wavetable::pulse1_3Table[WAVETABLE_LENGTH] = {
    0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
    0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
    0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
    0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
    0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
    0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
    0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
    0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,

    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,

    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,

    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40
};

uint8_t const Wavetable::pulse1_7Table[WAVETABLE_LENGTH] = {
    0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
    0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
    0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
    0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,

    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,

    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,

    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40
};

uint8_t const Wavetable::sawtoothTable[WAVETABLE_LENGTH] = {
    0x80, 0x81, 0x82, 0x83, 0x84, 0x85, 0x86, 0x87,
    0x88, 0x89, 0x8a, 0x8b, 0x8c, 0x8d, 0x8e, 0x8f,
    0x90, 0x91, 0x92, 0x93, 0x94, 0x95, 0x96, 0x97,
    0x98, 0x99, 0x9a, 0x9b, 0x9c, 0x9d, 0x9e, 0x9f,
    0xa0, 0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7,
    0xa8, 0xa9, 0xaa, 0xab, 0xac, 0xad, 0xae, 0xaf,
    0xb0, 0xb1, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7,
    0xb8, 0xb9, 0xba, 0xbb, 0xbc, 0xbd, 0xbe, 0xbf,
    
    0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7,
    0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf,
    0xd0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7,
    0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 0xdf,
    0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7,
    0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef,
    0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7,
    0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe, 0xff,
    
    0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,
    0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f,
    0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,
    0x18, 0x19, 0x1a, 0x1b, 0x1c, 0x1d, 0x1e, 0x1f,
    0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26, 0x27,
    0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f,
    0x30, 0x31, 0x32, 0x33, 0x34, 0x35, 0x36, 0x37,
    0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e, 0x3f,
    
    0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47,
    0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e, 0x4f,
    0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56, 0x57,
    0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f,
    0x60, 0x61, 0x62, 0x63, 0x64, 0x65, 0x66, 0x67,
    0x68, 0x69, 0x6a, 0x6b, 0x6c, 0x6d, 0x6e, 0x6f,
    0x70, 0x71, 0x72, 0x73, 0x74, 0x75, 0x76, 0x77,
    0x78, 0x79, 0x7a, 0x7b, 0x7c, 0x7d, 0x7e, 0x7f
};

uint8_t const Wavetable::triangleTable[WAVETABLE_LENGTH] = {
    0x80, 0x82, 0x84, 0x86, 0x88, 0x8a, 0x8c, 0x8e,
    0x90, 0x92, 0x94, 0x96, 0x98, 0x9a, 0x9c, 0x9e,
    0xa0, 0xa2, 0xa4, 0xa6, 0xa8, 0xaa, 0xac, 0xae,
    0xb0, 0xb2, 0xb4, 0xb6, 0xb8, 0xba, 0xbc, 0xbe,
    0xc0, 0xc2, 0xc4, 0xc6, 0xc8, 0xca, 0xcc, 0xce,
    0xd0, 0xd2, 0xd4, 0xd6, 0xd8, 0xda, 0xdc, 0xde,
    0xe0, 0xe2, 0xe4, 0xe6, 0xe8, 0xea, 0xec, 0xee,
    0xf0, 0xf2, 0xf4, 0xf6, 0xf8, 0xfa, 0xfc, 0xfe,
    
    0xff, 0xfe, 0xfc, 0xfa, 0xf8, 0xf6, 0xf4, 0xf2,
    0xf0, 0xee, 0xec, 0xea, 0xe8, 0xe6, 0xe4, 0xe2,
    0xe0, 0xde, 0xdc, 0xda, 0xd8, 0xd6, 0xd4, 0xd2,
    0xd0, 0xce, 0xcc, 0xca, 0xc8, 0xc6, 0xc4, 0xc2,
    0xc0, 0xbe, 0xbc, 0xba, 0xb8, 0xb6, 0xb4, 0xb2,
    0xb0, 0xae, 0xac, 0xaa, 0xa8, 0xa6, 0xa4, 0xa2,
    0xa0, 0x9e, 0x9c, 0x9a, 0x98, 0x96, 0x94, 0x92,
    0x90, 0x8e, 0x8c, 0x8a, 0x88, 0x86, 0x84, 0x82,

    0x80, 0x7e, 0x7c, 0x7a, 0x78, 0x76, 0x74, 0x72,
    0x70, 0x6e, 0x6c, 0x6a, 0x68, 0x66, 0x64, 0x62,
    0x60, 0x5e, 0x5c, 0x5a, 0x58, 0x56, 0x54, 0x52,
    0x50, 0x4e, 0x4c, 0x4a, 0x48, 0x46, 0x44, 0x42,
    0x40, 0x3e, 0x3c, 0x3a, 0x38, 0x36, 0x34, 0x32,
    0x30, 0x2e, 0x2c, 0x2a, 0x28, 0x26, 0x24, 0x22,
    0x20, 0x1e, 0x1c, 0x1a, 0x18, 0x16, 0x14, 0x12,
    0x10, 0x0e, 0x0c, 0x0a, 0x08, 0x06, 0x04, 0x02,
    
    0x00, 0x02, 0x04, 0x06, 0x08, 0x0a, 0x0c, 0x0e,
    0x10, 0x12, 0x14, 0x16, 0x18, 0x1a, 0x1c, 0x1e,
    0x20, 0x22, 0x24, 0x26, 0x28, 0x2a, 0x2c, 0x2e,
    0x30, 0x32, 0x34, 0x36, 0x38, 0x3a, 0x3c, 0x3e,
    0x40, 0x42, 0x44, 0x46, 0x48, 0x4a, 0x4c, 0x4e,
    0x50, 0x52, 0x54, 0x56, 0x58, 0x5a, 0x5c, 0x5e,
    0x60, 0x62, 0x64, 0x66, 0x68, 0x6a, 0x6c, 0x6e,
    0x70, 0x72, 0x74, 0x76, 0x78, 0x7a, 0x7c, 0x7e
};

uint8_t const Wavetable::coarseTriangleTable[WAVETABLE_LENGTH] = {
    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
    0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0,
    0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0,
    0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
    0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
    0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0,
    0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0,
    
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
    0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0,
    0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0, 0xe0,
    0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
    0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0, 0xc0,
    0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0,
    0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0, 0xa0,
    
    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60,
    0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60
};

uint8_t const Wavetable::spikedSineTable[WAVETABLE_LENGTH] = {
    0xa0, 0xa2, 0xa4, 0xa7, 0xa9, 0xab, 0xae, 0xb0,
    0x72, 0x75, 0x77, 0x79, 0x7b, 0x7e, 0x80, 0x82,
    0xc4, 0xc6, 0xc9, 0xcb, 0xcd, 0xcf, 0xd1, 0xd3,
    0x95, 0x97, 0x99, 0x9b, 0x9c, 0x9e, 0xa0, 0xa2,
    0xe3, 0xe5, 0xe7, 0xe8, 0xea, 0xeb, 0xed, 0xee,
    0xaf, 0xb1, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7,
    0xf8, 0xf9, 0xfa, 0xfb, 0xfb, 0xfc, 0xfd, 0xfd,
    0xbe, 0xbe, 0xbe, 0xbf, 0xbf, 0xbf, 0xbf, 0xbf,
    
    0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfe, 0xfe,
    0xbe, 0xbd, 0xbd, 0xbc, 0xbb, 0xbb, 0xba, 0xb9,
    0xf8, 0xf7, 0xf6, 0xf5, 0xf4, 0xf3, 0xf2, 0xf1,
    0xaf, 0xae, 0xad, 0xab, 0xaa, 0xa8, 0xa7, 0xa5,
    0xe3, 0xe2, 0xe0, 0xde, 0xdc, 0xdb, 0xd9, 0xd7,
    0x95, 0x93, 0x91, 0x8f, 0x8d, 0x8b, 0x89, 0x86,
    0xc4, 0xc2, 0xc0, 0xbe, 0xbb, 0xb9, 0xb7, 0xb5,
    0x72, 0x70, 0x6e, 0x6b, 0x69, 0x67, 0x64, 0x62,
    
    0x9f, 0x9d, 0x9b, 0x98, 0x96, 0x94, 0x91, 0x8f,
    0x4d, 0x4a, 0x48, 0x46, 0x44, 0x41, 0x3f, 0x3d,
    0x7b, 0x79, 0x76, 0x74, 0x72, 0x70, 0x6e, 0x6c,
    0x2a, 0x28, 0x26, 0x24, 0x23, 0x21, 0x1f, 0x1d,
    0x5c, 0x5a, 0x58, 0x57, 0x55, 0x54, 0x52, 0x51,
    0x10, 0x0e, 0x0d, 0x0c, 0x0b, 0x0a, 0x09, 0x08,
    0x47, 0x46, 0x45, 0x44, 0x44, 0x43, 0x42, 0x42,
    0x01, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00,
    
    0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x41, 0x41,
    0x01, 0x02, 0x02, 0x03, 0x04, 0x04, 0x05, 0x06,
    0x47, 0x48, 0x49, 0x4a, 0x4b, 0x4c, 0x4d, 0x4e,
    0x10, 0x11, 0x12, 0x14, 0x15, 0x17, 0x18, 0x1a,
    0x5c, 0x5d, 0x5f, 0x61, 0x63, 0x64, 0x66, 0x68,
    0x2a, 0x2c, 0x2e, 0x30, 0x32, 0x34, 0x36, 0x39,
    0x7b, 0x7d, 0x7f, 0x81, 0x84, 0x86, 0x88, 0x8a,
    0x4d, 0x4f, 0x51, 0x54, 0x56, 0x58, 0x5b, 0x5d
};
