#ifndef INSTRUMENT_H_
#define INSTRUMENT_H_

#include <stdint.h>
#include "Wavetable.h"

class Instrument {
private:
    uint16_t          samplingRate;      // sampling rate
    uint8_t           channelId;         // channel ID
    bool              enableFlag;        // enable flag (whether this instrument is enabled)
    int32_t           soundingPosition;  // currently sounding note position
    uint32_t          duration;          // sounding duration
    Wavetable::wave_t wave;          // wave parameters
    uint16_t          frequency;         // wave frequency
    uint8_t           masterVolume;      // + master volume
    uint8_t           volume;            //    |- volume
    uint8_t           expression;        //    |- expression    (volume multiplier)
    uint8_t           velocity;          //    |- note velocity (volume multiplier)
    uint16_t          phase;             // current phase          (x256)
    uint16_t          phaseDelta;        // phase delta per sample (x256)
    
public:
    Instrument();
    ~Instrument();

    void enable();
    void disable();
    void setSamplingRate(uint16_t);
    void advancePhase();
    void resetPhase();
    void setWave(Wavetable::wave_t);
    void setFrequency(uint16_t);
    void setVolume(uint8_t);
    void setExpression(uint8_t);
    void setVelocity(uint8_t);
    void resetDuration();
    
    uint16_t getSamplingRate();
    uint8_t getChannelId();
    bool isEnable();
    int16_t getSoundingPosition();
    uint32_t getDuration();
    Wavetable::wave_t getWave();
    uint16_t getFrequency();
    uint8_t getMasterVolume();
    uint8_t getVolume();
    uint8_t getExpression();
    uint8_t getVelocity();
    uint16_t getPhase();
    uint16_t getPhaseDelta();
    
private:
    void calculatePhaseDelta();
    void calculateMasterVolume();
};

#endif
